/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.util.Collections;

public class ActionHelper {
    protected static String extractSpaceKey(String pageString) {
        String[] results;
        if (TextUtils.stringSet((String)pageString) && (results = pageString.split(":")).length == 2) {
            return results[0];
        }
        return null;
    }

    protected static String extractPageTitle(String pageString) {
        if (!"".equals(pageString) && pageString != null) {
            String[] results = pageString.split(":");
            if (results.length == 2) {
                return results[1];
            }
            return pageString;
        }
        return null;
    }

    public static boolean isSpaceAdmin(Space space, User remoteUser, SpacePermissionManager spacePermissionManager) {
        return GeneralUtil.isSuperUser(remoteUser) || spacePermissionManager.hasPermission(Collections.singletonList("SETSPACEPERMISSIONS"), space, remoteUser);
    }
}

