/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.content.service.CommentService;
import com.atlassian.confluence.content.service.comment.CreateCommentCommand;
import com.atlassian.confluence.core.actions.ServiceBackedActionHelper;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.actions.AbstractPreviewPageAction;
import com.atlassian.confluence.security.CaptchaAware;
import com.atlassian.confluence.security.CaptchaManager;
import com.opensymphony.util.TextUtils;
import java.util.List;

public class AddCommentAction
extends AbstractPreviewPageAction
implements CaptchaAware {
    private CaptchaManager captchaManager;
    private CommentService commentService;
    private NotificationManager notificationManager;
    private CreateCommentCommand createCommentCommand;
    private long parentId;
    private boolean watchPageAfterComment;

    public void validate() {
        super.validate();
        if (!this.getAddCommentCommand().isValid()) {
            new ServiceBackedActionHelper(this.getAddCommentCommand()).addValidationErrors(this);
        }
    }

    public String execute() throws Exception {
        if (TextUtils.stringSet((String)this.back)) {
            return "input";
        }
        if (TextUtils.stringSet((String)this.preview)) {
            this.updateXHtmlContent();
            this.setInPreview(true);
            return PREVIEW;
        }
        this.updateXHtmlContent();
        this.getAddCommentCommand().execute();
        if (this.watchPageAfterComment) {
            this.notificationManager.addPageNotification(this.getRemoteUser(), this.getPage());
        }
        return "success";
    }

    public Comment getComment() {
        return this.getAddCommentCommand().getComment();
    }

    public boolean isPermitted() {
        return this.getAddCommentCommand().isAuthorized();
    }

    public List getPermittedChildren() {
        return super.getPermittedChildren();
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public long getParentId() {
        return this.parentId;
    }

    public String getCancelResult() {
        if (this.parentId != 0L) {
            return "cancel-to-parent";
        }
        return super.getCancelResult();
    }

    private CreateCommentCommand getAddCommentCommand() {
        if (this.createCommentCommand == null) {
            this.createCommentCommand = this.parentId == 0L ? this.commentService.newCreateCommentCommand(this.getPageId(), this.getWikiMarkupContent()) : this.commentService.newCreateCommentCommand(this.getPageId(), this.parentId, this.getWikiMarkupContent());
        }
        return this.createCommentCommand;
    }

    private String getWikiMarkupContent() {
        if (this.isXHtml) {
            this.content = this.wysiwygConverter.convertXHtmlToWikiMarkup(this.getPageOrDummyPage(), this.wysiwygContent);
        }
        return this.content;
    }

    public void setCommentService(CommentService commentService) {
        this.commentService = commentService;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setWatchPageAfterComment(boolean watchPageAfterComment) {
        this.watchPageAfterComment = watchPageAfterComment;
    }

    public CaptchaManager getCaptchaManager() {
        return this.captchaManager;
    }

    public void setCaptchaManager(CaptchaManager captchaManager) {
        this.captchaManager = captchaManager;
    }
}

