/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import bucket.core.actions.PaginationSupport;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.actions.AbstractPaginatedListAction;
import com.atlassian.confluence.util.GeneralUtil;
import com.opensymphony.util.TextUtils;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AlphabeticalListPagesAction
extends AbstractPaginatedListAction {
    private static final String PLUGIN_KEY = "list-alphabetically";
    public static final String DEFAULT_LETTER = "";
    private String startsWith;
    private int maxItems;
    private PageManager pageManager;

    public String execute() throws Exception {
        if (this.getSpace() == null) {
            return "pagenotfound";
        }
        GeneralUtil.setCookie("confluence.list.pages.cookie", PLUGIN_KEY);
        return super.execute();
    }

    public List getItems() {
        String startString = this.getStartsWith();
        List result = TextUtils.stringSet((String)startString) ? this.getPermittedEntitiesOf(this.pageManager.getPagesStartingWith(this.getSpace(), startString)) : this.getPermittedEntitiesOf(this.pageManager.getPages(this.getSpace(), true));
        if (result != null) {
            Collections.sort(result);
        }
        return result;
    }

    public void setStartsWith(String startsWith) {
        this.startsWith = StringUtils.isBlank((String)startsWith) || startsWith.length() > 1 || !StringUtils.isAlpha((String)startsWith) ? DEFAULT_LETTER : startsWith;
    }

    public String getStartsWith() {
        return this.startsWith;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
        this.paginationSupport = new PaginationSupport(maxItems);
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }
}

