/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.actions.AbstractCreatePageAction;
import com.atlassian.confluence.pages.actions.CalendarLanguageUtil;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CreateBlogPostAction
extends AbstractCreatePageAction {
    private static final Logger log = Logger.getLogger(CreateBlogPostAction.class);
    private static final int ONE_DAY = 86400000;

    public void validate() {
        if (this.titleIsSetToDefault("untitled.blog.title")) {
            this.setTitle("");
        }
        super.validate();
        if (this.getPostingDate() == null) {
            this.setPostingDate(new Date());
        }
        this.checkCreationDate();
        BlogPost post = this.pageManager.getBlogPost(this.getSpaceKey(), this.getTitle(), BlogPost.toCalendar(this.getPostingDate()));
        if (post != null) {
            this.addFieldError("title", this.getText("news.title.exists"));
        }
    }

    protected void createDraftIfItDoesNotExist() {
        this.draftManager.getOrCreate(AuthenticatedUserThreadLocal.getUsername(), "blogpost", this.getSpaceKey());
    }

    private void checkCreationDate() {
        if (this.getPostingDate().after(new Date(System.currentTimeMillis() + 86400000L))) {
            this.addActionError(this.getText("news.date.in.future"));
        }
    }

    protected AbstractPage getPageToCreate() {
        BlogPost blogPost = new BlogPost();
        blogPost.setCreationDate(this.hackPostingDate(this.getPostingDate().getTime()));
        return blogPost;
    }

    public void setPostingDay(String millisString) {
        if (StringUtils.isBlank((String)millisString)) {
            return;
        }
        try {
            long millis = Long.parseLong(millisString);
            this.setPostingDate(new Date(millis));
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Could not parse posting time [" + millisString + "] - current time is used"));
        }
    }

    private Date hackPostingDate(long millis) {
        ConfluenceUserPreferences userPreferences = this.userAccessor.getConfluenceUserPreferences(this.getRemoteUser());
        TimeZone userTimezone = userPreferences.getTimeZone();
        Calendar userCalendar = Calendar.getInstance(userTimezone.getWrappedTimeZone());
        userCalendar.setTimeInMillis(millis);
        Calendar systemCalendar = Calendar.getInstance(TimeZone.getDefault().getWrappedTimeZone());
        systemCalendar.setTimeInMillis(millis);
        if (systemCalendar.get(5) == userCalendar.get(5)) {
            return systemCalendar.getTime();
        }
        int diff = userTimezone.getWrappedTimeZone().getOffset(millis) - TimeZone.getDefault().getWrappedTimeZone().getOffset(millis);
        userCalendar.set(11, 0);
        userCalendar.set(12, 0);
        systemCalendar.setTimeInMillis(userCalendar.getTimeInMillis());
        if (systemCalendar.get(5) != userCalendar.get(5)) {
            userCalendar.add(14, Math.abs(diff));
        }
        systemCalendar.setTimeInMillis(userCalendar.getTimeInMillis());
        assert (systemCalendar.get(5) == userCalendar.get(5));
        return userCalendar.getTime();
    }

    public Date getPostingDate() {
        Date date = super.getPostingDate();
        return date == null ? new Date() : date;
    }

    protected List getPermissionTypes() {
        List permissionTypes = super.getPermissionTypes();
        this.addPermissionTypeTo("EDITBLOG", permissionTypes);
        if (permissionTypes.contains("EDITSPACE")) {
            permissionTypes.remove("EDITSPACE");
        }
        return permissionTypes;
    }

    public String getCalendarI18nFile() {
        return CalendarLanguageUtil.getInstance().getCalendarFilenameForLanguage(this.getLocale().getLanguage());
    }
}

