/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.content.service.CommentService;
import com.atlassian.confluence.content.service.comment.EditCommentCommand;
import com.atlassian.confluence.core.actions.ServiceBackedActionHelper;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.actions.AbstractPreviewPageAction;
import com.atlassian.confluence.security.CaptchaAware;
import com.atlassian.confluence.security.CaptchaManager;
import com.opensymphony.util.TextUtils;
import java.util.List;

public class EditCommentAction
extends AbstractPreviewPageAction
implements CaptchaAware {
    private CommentService commentService;
    private CaptchaManager captchaManager;
    private long commentId;

    public void validate() {
        super.validate();
        if (this.isXHtml) {
            this.content = this.wysiwygConverter.convertXHtmlToWikiMarkup(this.getPageOrDummyPage(), this.wysiwygContent);
        }
        if (!this.getEditCommentCommand().isValid()) {
            new ServiceBackedActionHelper(this.getEditCommentCommand()).addValidationErrors(this);
        }
    }

    public String doDefault() throws Exception {
        this.setContent(this.getComment().getContent());
        return "input";
    }

    public String doEdit() throws Exception {
        if (TextUtils.stringSet((String)this.back)) {
            return "input";
        }
        if (TextUtils.stringSet((String)this.preview)) {
            this.updateXHtmlContent();
            this.setInPreview(true);
            return PREVIEW;
        }
        this.updateXHtmlContent();
        this.getEditCommentCommand().execute();
        return "success";
    }

    public Comment getComment() {
        return this.getEditCommentCommand().getComment();
    }

    public boolean isPermitted() {
        return this.getEditCommentCommand().isAuthorized();
    }

    public long getCommentId() {
        return this.commentId;
    }

    public void setCommentId(long commentId) {
        this.commentId = commentId;
    }

    public List getPermittedChildren() {
        return super.getPermittedChildren();
    }

    public void setCommentService(CommentService commentService) {
        this.commentService = commentService;
    }

    private EditCommentCommand getEditCommentCommand() {
        return this.commentService.newEditCommentCommand(this.getCommentId(), this.getContent());
    }

    public CaptchaManager getCaptchaManager() {
        return this.captchaManager;
    }

    public void setCaptchaManager(CaptchaManager captchaManager) {
        this.captchaManager = captchaManager;
    }
}

