/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.content.service.SpaceService;
import com.atlassian.confluence.core.service.CommandActionHelper;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.AbstractEditPageAction;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionCheckDispatcherResultCache;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.EditPageBean;
import com.atlassian.confluence.util.GeneralUtil;
import com.opensymphony.util.TextUtils;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.SessionFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class EditPageAction
extends AbstractEditPageAction {
    private static final Logger log = Logger.getLogger(EditPageAction.class);
    private boolean moveHierarchy;
    private SessionFactory sessionFactory;
    private PermissionCheckDispatcherResultCache permissionCheckDispatcherResultCache;
    private PageService pageService;
    private CommandActionHelper helper;
    private SpaceService spaceService;

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.EDIT, this.getPage());
    }

    public void validate() {
        super.validate();
        if ((this.isTitleModified() || this.isSpaceModified()) && this.pageAlreadyExists()) {
            this.addFieldError("title", this.getText("page.title.exists.pagespecific", new String[]{this.getTitle(), this.spaceManager.getSpace(this.getNewSpaceKey()).getName()}));
        }
        if (!StringUtils.isEmpty((String)this.getPosition())) {
            this.getCommandActionHelper().validate(this);
        }
        if (this.getParentPage() != null) {
            if (!this.getParentPageSpaceKey().equals(this.getNewSpaceKey()) && !this.getParentPageSpaceKey().equals(this.getSpaceKey())) {
                this.addFieldError("parentPageString", this.getText("parent.page.not.in.same.space"));
            }
            if (this.getParentPageTitle().toLowerCase().equals(this.getPage().getTitle().toLowerCase())) {
                this.addFieldError("parentPageString", this.getText("page.cant.be.parent.of.itself"));
            }
            if (this.getParentPage().getAncestors().contains(this.getPage())) {
                this.addFieldError("parentPageString", this.getText("parent.cant.be.descendant"));
            }
            if (this.isSpaceModified() && this.pageManager.getPage(this.getNewSpaceKey(), this.getParentPageTitle()) == null) {
                this.addFieldError("parentPageString", this.getText("parent.page.invalid.for.space", new String[]{this.getParentPageTitle(), this.getNewSpaceKey()}));
            }
        }
        if (this.isSpaceModified()) {
            Space newSpace = this.spaceManager.getSpace(this.getNewSpaceKey());
            if (newSpace == null) {
                this.addFieldError("newSpaceKey", this.getText("move.page.invalid.space.key", new Object[]{this.getNewSpaceKey()}));
            }
            if (!this.permissionManager.hasCreatePermission(this.getRemoteUser(), newSpace, Page.class)) {
                this.addFieldError("newSpaceKey", this.getText("move.page.destination.permission.denied", new Object[]{newSpace.getName()}));
            }
        }
    }

    private CommandActionHelper getCommandActionHelper() {
        if (this.helper == null) {
            if ("topLevel".equals(this.getPosition())) {
                assert (this.getNewSpaceKey() != null);
                this.helper = new CommandActionHelper(this.pageService.newMovePageCommand(this.pageService.getIdPageLocator(this.getPageId()), this.spaceService.getKeySpaceLocator(this.getNewSpaceKey())));
            } else {
                this.helper = new CommandActionHelper(this.pageService.newMovePageCommand(this.pageService.getIdPageLocator(this.getPageId()), this.pageService.getIdPageLocator(this.targetId), this.getPosition()));
            }
        }
        return this.helper;
    }

    public String doDefault() throws Exception {
        Page parentPage;
        List escapedUserNames;
        List escapedGroupNames;
        if (this.getPage().hasPermissions("View")) {
            ContentPermissionSet viewContentPermissionSet = this.getPage().getContentPermissionSet("View");
            escapedGroupNames = GeneralUtil.escapeCommas(viewContentPermissionSet.getGroupNames());
            this.setViewPermissionsGroups(StringUtils.join(escapedGroupNames.iterator(), (String)", "));
            escapedUserNames = GeneralUtil.escapeCommas(viewContentPermissionSet.getUserNames());
            this.setViewPermissionsUsers(StringUtils.join(escapedUserNames.iterator(), (String)", "));
        }
        if (this.getPage().hasPermissions("Edit")) {
            ContentPermissionSet editContentPermissionSet = this.getPage().getContentPermissionSet("Edit");
            escapedGroupNames = GeneralUtil.escapeCommas(editContentPermissionSet.getGroupNames());
            this.setEditPermissionsGroups(StringUtils.join(escapedGroupNames.iterator(), (String)", "));
            escapedUserNames = GeneralUtil.escapeCommas(editContentPermissionSet.getUserNames());
            this.setEditPermissionsUsers(StringUtils.join(escapedUserNames.iterator(), (String)", "));
        }
        if ((parentPage = ((Page)this.getPage()).getParent()) != null) {
            this.setParentPageString(parentPage.getTitle());
        }
        this.getSession().remove(this.getBeanKey());
        return super.doDefault();
    }

    public String doSaveEditPageBean() {
        EditPageBean editPageBean = (EditPageBean)this.getSession().get(this.getBeanKey());
        this.setNewSpaceKey(editPageBean.getSpaceKey());
        this.setMoveHierarchy(editPageBean.isMoveHierarchy());
        this.setTitle(editPageBean.getTitle());
        this.setLabelsString(editPageBean.getLabels());
        this.setContent(editPageBean.getContent());
        this.setVersionComment(editPageBean.getVersionComment());
        this.setParentPageTitle(editPageBean.getParentPageTitle());
        this.setViewPermissionsUsers(editPageBean.getViewPermissionsUsers());
        this.setViewPermissionsGroups(editPageBean.getViewPermissionsGroups());
        this.setEditPermissionsUsers(editPageBean.getEditPermissionsUsers());
        this.setEditPermissionsGroups(editPageBean.getEditPermissionsGroups());
        this.setPosition(editPageBean.getPosition());
        this.setTargetId(Long.toString(editPageBean.getTargetId()));
        if (this.isTitleModified()) {
            this.getPage().setTitle(this.getTitle());
        }
        String result = super.doSaveEditPageBean();
        if (!StringUtils.isEmpty((String)this.getPosition())) {
            this.getCommandActionHelper().execute(this);
            try {
                SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)false).flush();
            }
            catch (HibernateException e) {
                log.error((Object)"Error flushing updates made on move hierarchy.", (Throwable)e);
            }
        }
        return result;
    }

    public String doEdit() throws Exception {
        this.setTitle(this.getTitle().trim());
        String result = super.doEdit();
        if ("success".equals(result)) {
            if (this.isContentModified() || this.isTitleModified() || this.isSpaceModified() || this.isParentPageChanged()) {
                AbstractPage page = this.getPage();
                page.setLastModificationDate(page.getCurrentDate());
                if (this.isAnonymousUser()) {
                    page.setLastModifierName(null);
                } else {
                    page.setLastModifierName(this.getRemoteUser().getName());
                }
            }
            this.saveEditPageBeanToSession();
            if (this.hasSetPagePermissionsPermission()) {
                this.contentPermissionManager.setContentPermissions(this.createEditPermissions(), this.getPage(), "Edit");
                this.contentPermissionManager.setContentPermissions(this.createViewPermissions(), this.getPage(), "View");
                this.permissionCheckDispatcherResultCache.flush();
            }
            if (this.isSpaceModified() && this.isMoveHierarchy()) {
                return "movehierarchy";
            }
            return this.doSaveEditPageBean();
        }
        return result;
    }

    private boolean isParentPageChanged() {
        Page parent = ((Page)this.getPage()).getParent();
        if (parent != null) {
            return !parent.getTitle().equals(this.parentPageTitle);
        }
        return TextUtils.stringSet((String)this.parentPageTitle);
    }

    protected boolean pageAlreadyExists() {
        if (this.getPage().getTitle().equalsIgnoreCase(this.getTitle()) && this.isTitleModified()) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)this.getPage().getSpaceKey()) && StringUtils.isNotEmpty((String)this.getTitle())) {
            return this.pageManager.getPage(this.getNewSpaceKey(), this.getTitle()) != null;
        }
        return false;
    }

    private boolean isSpaceModified() {
        return !this.getPage().getSpaceKey().equals(this.getNewSpaceKey());
    }

    private void saveEditPageBeanToSession() {
        EditPageBean bean = new EditPageBean();
        bean.setSpaceKey(this.getNewSpaceKey());
        bean.setMoveHierarchy(this.isMoveHierarchy());
        bean.setTitle(this.getTitle());
        bean.setLabels(this.getLabelsString());
        bean.setContent(this.getContent());
        bean.setVersionComment(this.getVersionComment());
        bean.setParentPageTitle(this.getParentPageTitle());
        bean.setPosition(this.getPosition());
        bean.setTargetId(this.getTargetId());
        bean.setViewPermissionsGroups(this.getViewPermissionsGroups());
        bean.setViewPermissionsUsers(this.getViewPermissionsUsers());
        bean.setEditPermissionsGroups(this.getEditPermissionsGroups());
        bean.setEditPermissionsUsers(this.getEditPermissionsUsers());
        this.getSession().put(this.getBeanKey(), bean);
    }

    public boolean isMoveHierarchy() {
        return this.moveHierarchy;
    }

    public void setMoveHierarchy(boolean moveHierarchy) {
        this.moveHierarchy = moveHierarchy;
    }

    public void setPermissionCheckDispatcherResultCache(PermissionCheckDispatcherResultCache permissionCheckDispatcherResultCache) {
        this.permissionCheckDispatcherResultCache = permissionCheckDispatcherResultCache;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setSpaceService(SpaceService spaceService) {
        this.spaceService = spaceService;
    }

    public void setPageService(PageService pageService) {
        this.pageService = pageService;
    }
}

