/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;
import com.atlassian.confluence.util.EditPageBean;
import com.atlassian.core.util.PairType;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.interceptor.ParameterAware;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;

public class HandleNameConflictsAction
extends AbstractPageAwareAction
implements ParameterAware {
    private static final Category log = Category.getInstance(HandleNameConflictsAction.class);
    private static final String TEXTBOX_PREFIX = "page-";
    private List pagesWithNameConflicts;
    private Map<String, String[]> parameters;
    private PageManager pageManager;

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public String doDefault() throws Exception {
        return this.getNextAction(this.getPagesWithNameConflicts());
    }

    public String execute() throws Exception {
        for (String fieldName : this.parameters.keySet()) {
            long pageId = this.getPageIdFromTextBoxName(fieldName);
            if (pageId == -1L) continue;
            AbstractPage currentPage = (AbstractPage)this.pageManager.getById(pageId);
            String currentPageTitle = currentPage.getTitle();
            String newPageTitle = this.findValueForFieldInRequestParams(fieldName);
            if (TextUtils.noNull((String)currentPageTitle).equals(newPageTitle)) continue;
            this.pageManager.renamePage(currentPage, newPageTitle);
        }
        return this.getNextAction(this.getPagesWithNameConflicts());
    }

    private String getNextAction(List nameConflicts) {
        if (nameConflicts.isEmpty()) {
            return "success";
        }
        return "input";
    }

    private List checkAndRecordNameConflict(Page page, boolean checkChildren) {
        ArrayList<PairType> result = new ArrayList<PairType>();
        if (page.hasChildren() && checkChildren) {
            for (Page childPage : page.getChildren()) {
                result.addAll(this.checkAndRecordNameConflict(childPage, checkChildren));
            }
        }
        if (this.isPageNameAlreadyExistsIn(this.getEditPageBean().getSpaceKey(), page) && !page.isRootLevel()) {
            result.add(new PairType((Serializable)((Object)page.getIdAsString()), (Serializable)page));
        }
        return result;
    }

    public String getTextBoxName(AbstractPage page) {
        return TEXTBOX_PREFIX + page.getIdAsString();
    }

    private boolean isPageNameAlreadyExistsIn(String newSpaceKey, AbstractPage page) {
        return this.pageManager.getPage(newSpaceKey, page.getTitle()) != null;
    }

    private long getPageIdFromTextBoxName(String name) {
        long result = -1L;
        try {
            if (TextUtils.noNull((String)name).startsWith(TEXTBOX_PREFIX)) {
                result = Long.parseLong(name.substring(TEXTBOX_PREFIX.length()));
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)("Error extracting page id from form name: " + name));
        }
        return result;
    }

    private String findValueForFieldInRequestParams(String fieldName) {
        String fieldValue = ServletActionContext.getRequest().getParameter(fieldName);
        return TextUtils.noNull((String)fieldValue);
    }

    public List getPagesWithNameConflicts() {
        if (this.pagesWithNameConflicts == null) {
            this.pagesWithNameConflicts = this.checkAndRecordNameConflict((Page)this.getPage(), this.getEditPageBean().isMoveHierarchy());
        }
        return this.pagesWithNameConflicts;
    }

    public EditPageBean getEditPageBean() {
        return (EditPageBean)this.getSession().get("confluence.edit.page.bean" + this.getPage().getId());
    }
}

