/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.actions.ViewPageAttachmentsAction;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.confluence.pages.thumbnail.Thumbnails;
import com.atlassian.confluence.util.ConfluenceRenderUtils;
import com.atlassian.xwork.FileUploadUtils;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class InsertImageInPageAction
extends ViewPageAttachmentsAction {
    private static final Logger log = Logger.getLogger(InsertImageInPageAction.class);
    private String formname;
    private String fieldname;
    private Thumbnails thumbnails;
    private ThumbnailManager thumbnailManager;
    private String fileName;

    private void validateUpload() {
        super.validate();
        try {
            FileUploadUtils.checkMultiPartRequestForErrors((MultiPartRequestWrapper)this.getMultiPartRequest());
        }
        catch (FileUploadUtils.FileUploadException e) {
            this.addActionError(this.getText("multipart.request.error"));
            log.warn((Object)"An error occured uploading a file to the server.", (Throwable)e);
        }
        Enumeration fileParameterNames = this.getMultiPartRequest().getFileParameterNames();
        while (fileParameterNames.hasMoreElements()) {
            Attachment attachment;
            String fileParameterName = TextUtils.noNull((String)((String)fileParameterNames.nextElement()));
            this.fileName = this.getMultiPartRequest().getFileNames(fileParameterName)[0];
            if (this.fileName == null) {
                this.addActionError(this.getText("null.file.error"));
            } else if (!(this.fileName.toLowerCase().endsWith(".gif") || this.fileName.toLowerCase().endsWith(".png") || this.fileName.toLowerCase().endsWith(".jpg"))) {
                this.addActionError(this.fileName + " " + this.getText("unsupported.file.error"));
            }
            if ((attachment = this.getContentEntityObject().getAttachmentNamed(this.fileName)) == null || !attachment.getFileName().equalsIgnoreCase(this.fileName)) continue;
            this.thumbnailManager.getThumbnailFile(attachment).delete();
        }
    }

    public String doDefault() throws Exception {
        this.loadThumbnails();
        return super.doDefault();
    }

    public String execute() throws Exception {
        this.validateUpload();
        super.execute();
        this.loadThumbnails();
        return "success";
    }

    private void loadThumbnails() {
        String attachmentRoot = ConfluenceRenderUtils.getAttachmentsRemotePath(this.getContentEntityObject().toPageContext());
        this.thumbnails = new Thumbnails(this.getLatestVersionsOfAttachments(), attachmentRoot, 3, this.attachmentManager, this.thumbnailManager);
    }

    public Thumbnails getThumbnails() {
        return this.thumbnails;
    }

    public ThumbnailManager getThumbnailManager() {
        return this.thumbnailManager;
    }

    public void setThumbnailManager(ThumbnailManager thumbnailManager) {
        this.thumbnailManager = thumbnailManager;
    }

    public String getFormname() {
        return this.formname;
    }

    public void setFormname(String formname) {
        this.formname = formname;
    }

    public String getFieldname() {
        return this.fieldname;
    }

    public void setFieldname(String fieldname) {
        this.fieldname = fieldname;
    }

    public String getFileName() {
        return this.fileName;
    }
}

