/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.actions.AbstractPaginatedListAction;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ListUndefinedPagesAction
extends AbstractPaginatedListAction {
    private PageManager pageManager;

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public List getUndefinedPages() {
        return this.paginationSupport.getItems();
    }

    public List getItems() {
        List links = this.getPermittedEntitiesOf(this.pageManager.getUndefinedPages(this.key));
        HashMap<String, UndefinedPage> condensedLinks = new HashMap<String, UndefinedPage>();
        for (OutgoingLink outgoingLink : links) {
            String destinationPageTitle = outgoingLink.getDestinationPageTitle();
            if (!TextUtils.stringSet((String)destinationPageTitle) || destinationPageTitle.indexOf("/") != -1) continue;
            String mapKey = (outgoingLink.getDestinationSpaceKey() + ":" + destinationPageTitle).toLowerCase();
            UndefinedPage undefPage = (UndefinedPage)condensedLinks.get(mapKey);
            if (undefPage == null) {
                undefPage = new UndefinedPage(outgoingLink.getDestinationSpaceKey(), outgoingLink.getDestinationPageTitle());
                condensedLinks.put(mapKey, undefPage);
            }
            undefPage.getReferencedFrom().add(outgoingLink.getSourceContent());
        }
        ArrayList undefinedLinks = new ArrayList(condensedLinks.size());
        undefinedLinks.addAll(condensedLinks.values());
        Collections.sort(undefinedLinks);
        return undefinedLinks;
    }

    public static class UndefinedPage
    implements Comparable {
        private final String destinationSpaceKey;
        private final String destinationPageTitle;
        private final List referencedFrom = new ArrayList();

        public UndefinedPage(String spaceKey, String pageTitle) {
            this.destinationSpaceKey = spaceKey;
            this.destinationPageTitle = pageTitle;
        }

        public String getDestinationSpaceKey() {
            return this.destinationSpaceKey;
        }

        public String getDestinationPageTitle() {
            return this.destinationPageTitle;
        }

        public List getReferencedFrom() {
            return this.referencedFrom;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UndefinedPage that = (UndefinedPage)o;
            if (this.destinationPageTitle != null ? !this.destinationPageTitle.equals(that.destinationPageTitle) : that.destinationPageTitle != null) {
                return false;
            }
            return !(this.destinationSpaceKey != null ? !this.destinationSpaceKey.equals(that.destinationSpaceKey) : that.destinationSpaceKey != null);
        }

        public int hashCode() {
            int result = this.destinationSpaceKey != null ? this.destinationSpaceKey.hashCode() : 0;
            result = 29 * result + (this.destinationPageTitle != null ? this.destinationPageTitle.hashCode() : 0);
            return result;
        }

        public int compareTo(Object o) {
            UndefinedPage other = (UndefinedPage)o;
            int i = this.destinationPageTitle.compareTo(other.destinationPageTitle);
            return i == 0 ? this.destinationSpaceKey.compareTo(other.destinationSpaceKey) : i;
        }
    }
}

