/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.links.AbstractLink;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.links.ReferralLink;
import com.atlassian.confluence.links.linktypes.AbstractContentEntityLink;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.ViewPageAction;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.PageChangesBean;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.LinkResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageInfoAction
extends ViewPageAction {
    private static final Logger log = Logger.getLogger(PageInfoAction.class);
    private MultiValueMap outgoingLinks;
    private MultiValueMap incomingLinksMap;
    private Collection<OutgoingLink> externalLinks;
    private LinkResolver linkResolver;
    private static final int MAX_REVISIONS = 5;
    private List latestChanges;
    private static final int INITIAL_VISIBLE_CHILD_COUNT = 10;
    private List<VersionHistorySummary> versionHistorySummaryList;
    private static final int URL_DISPLAY_LENGTH = 60;

    @Override
    public String execute() throws Exception {
        this.versionHistorySummaryList = this.pageManager.getVersionHistorySummaries(this.getPage());
        return super.execute();
    }

    public void setLinkResolver(LinkResolver linkResolver) {
        this.linkResolver = linkResolver;
    }

    public Map<Space, SpaceContentEntityObject> getIncomingLinksMap() {
        if (this.incomingLinksMap == null) {
            HashSet<OutgoingLink> incomingLinksSet = new HashSet<OutgoingLink>();
            incomingLinksSet.addAll(this.getIncomingLinks());
            this.incomingLinksMap = new MultiValueMap();
            for (OutgoingLink outgoingLink : incomingLinksSet) {
                SpaceContentEntityObject spaceContentEntityObject;
                ContentEntityObject sourceContent = outgoingLink.getSourceContent();
                if (!(sourceContent instanceof SpaceContentEntityObject) || (spaceContentEntityObject = (SpaceContentEntityObject)sourceContent).isDeleted()) continue;
                this.incomingLinksMap.put((Object)spaceContentEntityObject.getSpace(), (Object)spaceContentEntityObject);
            }
        }
        return this.incomingLinksMap;
    }

    public List getTrackbackLinks() {
        if (!this.settingsManager.getGlobalSettings().isAllowTrackbacks()) {
            return Collections.EMPTY_LIST;
        }
        return this.getPage().getTrackbackLinks();
    }

    public Map<Space, SpaceContentEntityObject> getOutgoingLinks() {
        if (this.outgoingLinks == null) {
            HashSet noDuplicatesSet = new HashSet();
            noDuplicatesSet.addAll(this.getPage().getOutgoingLinks());
            this.outgoingLinks = new MultiValueMap();
            this.externalLinks = new HashSet<OutgoingLink>();
            for (OutgoingLink outgoingLink : noDuplicatesSet) {
                ContentEntityObject destinationContent = this.getDestinationContentEntity(outgoingLink);
                if (destinationContent instanceof Page) {
                    this.outgoingLinks.put((Object)((Page)destinationContent).getSpace(), (Object)destinationContent);
                    continue;
                }
                if (!outgoingLink.isUrlLink()) continue;
                this.externalLinks.add(outgoingLink);
            }
        }
        return this.outgoingLinks;
    }

    public Collection getExternalLinks() {
        if (this.externalLinks == null) {
            this.getOutgoingLinks();
        }
        return this.externalLinks;
    }

    public String renderOutgoingLink(AbstractLink link) {
        if (link instanceof ReferralLink) {
            String url = ((ReferralLink)link).getUrl();
            return this.url2HtmlLink(url);
        }
        OutgoingLink outLink = (OutgoingLink)link;
        AbstractPage page = (AbstractPage)outLink.getSourceContent();
        if (outLink.getDestinationSpaceKey().equals(page.getSpace().getKey())) {
            return this.renderLink(outLink.getDestinationPageTitle());
        }
        if (((OutgoingLink)link).isUrlLink()) {
            return this.url2HtmlLink(((OutgoingLink)link).getUrlLink());
        }
        return this.renderLink(((OutgoingLink)link).getUrlLink());
    }

    public String renderReferralLink(ReferralLink link) {
        return this.url2HtmlLink(link.getUrl());
    }

    public String renderUrlLink(OutgoingLink link) {
        if (link.isUrlLink()) {
            return this.url2HtmlLink(link.getUrlLink());
        }
        return null;
    }

    private String url2HtmlLink(String url) {
        String shortenedUrl = GeneralUtil.displayShortUrl(url, 60);
        return "<a href=\"" + GeneralUtil.htmlEncode(url) + "\" title=\"" + GeneralUtil.htmlEncode(url) + "\" rel=\"nofollow\">" + GeneralUtil.htmlEncode(shortenedUrl) + "</a>";
    }

    public ContentEntityObject getDestinationContentEntity(OutgoingLink link) {
        Link sLinky = this.linkResolver.createLink((RenderContext)this.getPage().toPageContext(), link.getDestinationSpaceKey() + ":" + link.getDestinationPageTitle());
        if (sLinky instanceof AbstractContentEntityLink) {
            return ((AbstractContentEntityLink)sLinky).getDestinationContent();
        }
        return null;
    }

    @Override
    public boolean isLatestVersionRequired() {
        return true;
    }

    @Override
    public boolean isViewPermissionRequired() {
        return true;
    }

    public PageChangesBean getChangesSinceLastEdit() {
        try {
            if (this.getRemoteUser() == null) {
                return null;
            }
            LinkedHashSet<String> previousAuthorsSet = new LinkedHashSet<String>();
            int edits = 0;
            for (VersionHistorySummary versionHistorySummary : this.versionHistorySummaryList) {
                if (versionHistorySummary.getLastModifierName() != null && versionHistorySummary.getLastModifierName().equals(this.getRemoteUser().getName())) {
                    return edits == 0 ? null : new PageChangesBean(edits, new ArrayList<String>(previousAuthorsSet));
                }
                ++edits;
                previousAuthorsSet.add(versionHistorySummary.getLastModifierName());
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)("Error getting changes since last edit: " + e), (Throwable)e);
            return null;
        }
    }

    public PageChangesBean getChangesSinceLastLogin() {
        try {
            if (this.getRemoteUser() == null) {
                return null;
            }
            LinkedHashSet<String> previousAuthorsSet = new LinkedHashSet<String>();
            int edits = 0;
            for (VersionHistorySummary versionHistorySummary : this.versionHistorySummaryList) {
                Date modificationDate = versionHistorySummary.getLastModificationDate();
                Date previousLoginDate = this.getPreviousLoginDate();
                if (previousLoginDate != null && (modificationDate.before(previousLoginDate) || modificationDate.equals(previousLoginDate))) {
                    return edits == 0 ? null : new PageChangesBean(edits, new ArrayList<String>(previousAuthorsSet));
                }
                ++edits;
                previousAuthorsSet.add(versionHistorySummary.getLastModifierName());
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)("Error getting changes since last edit: " + e), (Throwable)e);
            return null;
        }
    }

    public List getLatestChanges() {
        if (this.latestChanges == null) {
            this.latestChanges = this.versionHistorySummaryList.size() > 5 ? this.versionHistorySummaryList.subList(0, 5) : this.versionHistorySummaryList;
        }
        return this.latestChanges;
    }

    public int getInitialVisibleChildCount() {
        return 10;
    }
}

