/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.opensymphony.webwork.ServletActionContext;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;

public class PageNotPermittedAction
extends AbstractPageAwareAction {
    private long pageId;
    private String originalurl;

    public String execute() throws IOException {
        if (this.getRemoteUser() == null) {
            HttpServletRequest request = ServletActionContext.getRequest();
            this.originalurl = GeneralUtil.urlEncode(request.getServletPath() + (request.getQueryString() == null ? "" : "?" + request.getQueryString()));
            return "login";
        }
        return "success";
    }

    public long getPageId() {
        return this.pageId;
    }

    public boolean isPermitted() {
        return true;
    }

    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    public boolean isPermittedToViewCurrentPage() {
        if (this.getPage().hasPermissions("View")) {
            return this.getPage().getContentPermissionSet("View").isPermitted(this.getRemoteUser());
        }
        return true;
    }

    public String getOriginalurl() {
        return this.originalurl;
    }

    public String getLoginUrl() {
        return SecurityConfigFactory.getInstance().getLoginURL();
    }
}

