/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.json.JSONAction;
import com.atlassian.confluence.json.JSONException;
import com.atlassian.confluence.json.JSONObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.util.GeneralUtil;

public class PageSummaryAction
extends ConfluenceActionSupport
implements JSONAction {
    private long pageId;
    private PageManager pageManager;

    public String getJSONString() {
        try {
            Page page = this.pageManager.getPage(this.pageId);
            String rawContent = page.getContent();
            int contentLength = rawContent.length();
            if (contentLength > 1000) {
                rawContent = rawContent.substring(0, 1000) + "\n\n...\n\n+ " + (contentLength - 1000) + " chars";
            }
            rawContent = GeneralUtil.htmlEncode(rawContent);
            JSONObject summary = new JSONObject();
            summary.put("excerpt", rawContent);
            summary.put("createddate", page.getCreationDate());
            summary.put("lastupdateddate", page.getLastModificationDate());
            summary.put("createdby", page.getCreatorName());
            summary.put("lastupdatedby", page.getLastModifierName());
            return summary.toString();
        }
        catch (JSONException e) {
            throw new IllegalStateException("Can't construct JSON data");
        }
    }

    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }
}

