/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.pages.actions.CreatePageAction;
import com.atlassian.confluence.pages.templates.variables.StringVariable;
import com.opensymphony.xwork.ActionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PageVariablesAction
extends CreatePageAction {
    private List templateVariables;
    private boolean templateApplied = false;
    private static final String VARIABLE_VALUE_PARAM_PREFIX = "variableValues.";
    private static final String NO_VARIABLES_IN_TEMPLATE = "novariables";

    public List getTemplateVariables() {
        if (this.templateVariables == null) {
            this.templateVariables = this.pageTemplateManager.getTemplateVariables(this.getPageTemplate());
        }
        return this.templateVariables;
    }

    public String execute() throws Exception {
        if (this.getTemplateVariables() == null || this.getTemplateVariables().size() == 0) {
            if (this.getPageTemplate() != null) {
                this.content = this.pageTemplateManager.mergeVariables(this.getPageTemplate(), new ArrayList());
                this.setLabelsString(this.getPageTemplate().getLabels());
                this.setTemplateApplied(true);
            }
            return NO_VARIABLES_IN_TEMPLATE;
        }
        this.content = this.getPageTemplate().getContent();
        this.setLabelsString(this.getPageTemplate().getLabels());
        return "input";
    }

    public String doEnter() {
        this.populateParentPageTitleField();
        ArrayList<StringVariable> variables = new ArrayList<StringVariable>();
        Map params = ActionContext.getContext().getParameters();
        for (String key : params.keySet()) {
            if (!key.startsWith(VARIABLE_VALUE_PARAM_PREFIX)) continue;
            StringVariable variable = new StringVariable(key.substring(VARIABLE_VALUE_PARAM_PREFIX.length()), ((String[])params.get(key))[0]);
            variables.add(variable);
        }
        if (variables.size() > 0) {
            this.content = this.pageTemplateManager.mergeVariables(this.getPageTemplate(), variables);
            this.setTemplateApplied(true);
            this.setLabelsString(this.getPageTemplate().getLabels());
        }
        return "success";
    }

    public void validate() {
    }

    public boolean isPermitted() {
        return true;
    }

    public boolean isTemplateApplied() {
        return this.templateApplied;
    }

    public void setTemplateApplied(boolean templateApplied) {
        this.templateApplied = templateApplied;
    }
}

