/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.mail.MailContentManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.util.GeneralUtil;

public class PurgeTrashItemAction
extends AbstractSpaceAction {
    protected ContentEntityManager contentEntityManager;
    protected ContentEntityObject contentEntityObject;
    protected MailContentManager mailContentManager;
    protected PageManager pageManager;
    protected long contentId;
    protected String Type;

    public void validate() {
        super.validate();
        if (this.getContentEntityObject().isCurrent()) {
            this.addActionError(this.getText("error.purge.non.trash"));
        }
    }

    public String execute() throws Exception {
        ContentEntityObject object = this.getContentEntityObject();
        if (object instanceof AbstractPage) {
            ((AbstractPage)object).remove(this.pageManager);
        } else if (object instanceof Mail) {
            this.mailContentManager.removeMail((Mail)object);
        }
        return "success";
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public long getContentId() {
        return this.contentId;
    }

    public void setContentId(long contentId) {
        this.contentId = contentId;
    }

    public boolean isPermitted() {
        return GeneralUtil.isSuperUser(this.getRemoteUser()) || this.permissionManager.hasPermission(this.getRemoteUser(), Permission.VIEW, this.getSpace()) && this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, this.getSpace());
    }

    public ContentEntityObject getContentEntityObject() {
        if (this.contentEntityObject == null) {
            this.contentEntityObject = this.contentEntityManager.getById(this.contentId);
        }
        return this.contentEntityObject;
    }

    public String getType() {
        return this.getNiceContentType(this.getContentEntityObject());
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setMailContentManager(MailContentManager mailContentManager) {
        this.mailContentManager = mailContentManager;
    }
}

