/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.core.actions.RssDescriptor;
import com.atlassian.confluence.pages.BlogPostsCalendar;
import com.atlassian.confluence.pages.actions.AbstractBlogPostsAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.util.GeneralUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class RecentBlogPostsAction
extends AbstractBlogPostsAction
implements SpaceAware {
    private List recentBlogs;
    private BlogPostsCalendar calendar;
    private static final String PLUGIN_KEY = "space-blogposts";

    public List getBlogPosts() {
        return this.recentBlogs;
    }

    public String execute() throws Exception {
        this.recentBlogs = this.pageManager.getRecentlyAddedBlogPosts(15, this.getKey());
        GeneralUtil.setCookie("confluence.browse.space.cookie", PLUGIN_KEY);
        return super.execute();
    }

    public BlogPostsCalendar getCalendarForThisMonth() {
        Calendar postingDay = Calendar.getInstance();
        postingDay.setTime(new Date());
        if (this.calendar == null) {
            this.calendar = new BlogPostsCalendar(postingDay.getTime(), this.pageManager.getBlogPosts(this.getKey(), postingDay, 2), this.getKey());
            this.calendar.setFirstPostInNextMonth(this.getFirstPostInNextMonth(postingDay));
            this.calendar.setLastPostInPreviousMonth(this.getLastPostInPreviousMonth(postingDay));
        }
        return this.calendar;
    }

    public RssDescriptor getRssDescriptor() {
        String title = this.getText("rss.descriptor.space.news.items", new Object[]{this.getSpace().getName()});
        return new RssDescriptor("/spaces/createrssfeed.action?types=blogpost&spaces=" + GeneralUtil.urlEncode(this.getKey()) + "&sort=modified&title=" + GeneralUtil.urlEncode(title) + "&maxResults=15", title, this.getRemoteUser() != null);
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }
}

