/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.links.LinkManager;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;
import com.atlassian.confluence.pages.actions.ActionHelper;
import com.atlassian.confluence.pages.actions.beans.PageIncomingLinks;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.util.GeneralUtil;
import com.opensymphony.util.TextUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemovePageAction
extends AbstractPageAwareAction {
    private String spaceKey;
    private ConfluenceIndexer indexer;
    private Page cachedParent;
    private PageManager pageManager;
    private LinkManager linkManager;

    public void setIndexer(ConfluenceIndexer indexer) {
        this.indexer = indexer;
    }

    public void setLinkManager(LinkManager linkManager) {
        this.linkManager = linkManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public String doRemove() throws Exception {
        if (this.getPage() instanceof Page) {
            this.cachedParent = ((Page)this.getPage()).getParent();
        }
        this.spaceKey = super.getSpaceKey();
        this.pageManager.trashPage(this.getPage());
        return "success";
    }

    @Override
    public String getSpaceKey() {
        if (TextUtils.stringSet((String)this.spaceKey)) {
            return this.spaceKey;
        }
        return super.getSpaceKey();
    }

    protected List getPermissionTypes() {
        List<String> permissionTypes = super.getPermissionTypes();
        permissionTypes.add("VIEWSPACE");
        if (this.getPage() instanceof Page) {
            this.addPermissionTypeTo("REMOVEPAGE", permissionTypes);
        } else {
            this.addPermissionTypeTo("REMOVEBLOG", permissionTypes);
        }
        return permissionTypes;
    }

    @Override
    public boolean isPermitted() {
        return (this.isSpaceAdmin() || this.contentPermissionManager.hasContentLevelPermission(this.getRemoteUser(), "Edit", this.getPage())) && super.isPermitted();
    }

    public List<OutgoingLink> getIncomingLinks() {
        return new PageIncomingLinks(this.linkManager, this.permissionManager).getIncomingLinks(this.getPage(), this.getRemoteUser());
    }

    public String getRedirectUrl() {
        Page pageToReturn = this.cachedParent;
        if (pageToReturn == null) {
            pageToReturn = this.getSpace().getHomePage();
        }
        if (pageToReturn == null) {
            return "/pages/listpages-alphaview.action?key=" + GeneralUtil.urlEncode(this.getSpaceKey());
        }
        return GeneralUtil.getPageUrl(pageToReturn);
    }

    @Override
    public boolean isLatestVersionRequired() {
        return true;
    }

    @Override
    public boolean isViewPermissionRequired() {
        return true;
    }

    public ConfluenceIndexer getIndexer() {
        return this.indexer;
    }

    private boolean isSpaceAdmin() {
        return ActionHelper.isSpaceAdmin(this.getSpace(), this.getRemoteUser(), this.spacePermissionManager);
    }
}

