/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;
import com.atlassian.confluence.pages.actions.ActionHelper;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionCheckDispatcherResultCache;
import com.atlassian.confluence.util.GeneralUtil;
import com.opensymphony.util.TextUtils;
import java.util.Collections;

public class RemovePagePermissionAction
extends AbstractPageAwareAction {
    private PermissionCheckDispatcherResultCache permissionCheckDispatcherResultCache;
    private long permissionId;
    private boolean removeAll;
    private String returnPath;

    public void setPermissionCheckDispatcherResultCache(PermissionCheckDispatcherResultCache permissionCheckDispatcherResultCache) {
        this.permissionCheckDispatcherResultCache = permissionCheckDispatcherResultCache;
    }

    public void setPermissionId(long permissionId) {
        this.permissionId = permissionId;
    }

    public void setRemoveAll(boolean removeAll) {
        this.removeAll = removeAll;
    }

    public String getReturnPath() {
        return this.returnPath;
    }

    public void setReturnPath(String returnPath) {
        this.returnPath = returnPath;
    }

    public String execute() {
        if (this.removeAll) {
            this.contentPermissionManager.setContentPermissions(Collections.EMPTY_LIST, this.getPage(), "View");
            this.contentPermissionManager.setContentPermissions(Collections.EMPTY_LIST, this.getPage(), "Edit");
        } else {
            ContentPermission permission = this.getPermissionFromPage(this.getPage(), this.permissionId);
            if (permission != null) {
                this.contentPermissionManager.removeContentPermission(permission);
            }
        }
        this.permissionCheckDispatcherResultCache.flush();
        if (TextUtils.stringSet((String)this.returnPath)) {
            return "returnPath";
        }
        return "success";
    }

    private ContentPermission getPermissionFromPage(AbstractPage page, long permissionId) {
        for (Object o : page.getPermissions()) {
            ContentPermission permission = (ContentPermission)o;
            if (permission.getId() != permissionId) continue;
            return permission;
        }
        return null;
    }

    public boolean isPermitted() {
        if (GeneralUtil.isSuperUser(this.getRemoteUser())) {
            return true;
        }
        return this.isSpaceAdmin() || this.permissionManager.hasPermission(this.getRemoteUser(), Permission.EDIT, this.getPage());
    }

    private boolean isSpaceAdmin() {
        return ActionHelper.isSpaceAdmin(this.getSpace(), this.getRemoteUser(), this.spacePermissionManager);
    }
}

