/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAdministrative;
import java.util.Collection;

public class RestoreTrashItemAction
extends AbstractSpaceAction
implements SpaceAdministrative {
    protected ContentEntityManager contentEntityManager;
    protected SpaceContentEntityObject spaceContentEntityObject;
    protected PageManager pageManager;
    protected long contentId;
    protected long existingContentId;
    private ConfluenceIndexer indexer;

    private ContentEntityObject findExistingObject(SpaceContentEntityObject object) {
        if (object instanceof Page) {
            return this.pageManager.getPage(object.getSpaceKey(), object.getTitle());
        }
        if (object instanceof BlogPost) {
            return this.pageManager.getBlogPost(object.getSpaceKey(), object.getTitle(), BlogPost.toCalendar(object.getCreationDate()));
        }
        return null;
    }

    public String execute() throws Exception {
        ContentEntityObject ceo = this.findExistingObject(this.getSpaceContentEntityObject());
        if (ceo != null) {
            this.existingContentId = ceo.getId();
            return "restoreexisting";
        }
        return "input";
    }

    public String doRestore() {
        SpaceContentEntityObject spaceContentEntityObject = this.getSpaceContentEntityObject();
        if (spaceContentEntityObject instanceof AbstractPage) {
            AbstractPage page = (AbstractPage)spaceContentEntityObject;
            this.pageManager.restorePage(page);
        } else {
            spaceContentEntityObject.setContentStatus("current");
            this.contentEntityManager.saveContentEntity(this.getSpaceContentEntityObject(), null);
            this.restoreIndex(this.getSpaceContentEntityObject());
        }
        return "success";
    }

    private void restoreIndex(Searchable ceo) {
        Collection dependents = ceo.getSearchableDependants();
        for (Searchable s : dependents) {
            this.restoreIndex(s);
        }
        this.indexer.index(ceo);
    }

    public SpaceContentEntityObject getSpaceContentEntityObject() {
        return (SpaceContentEntityObject)this.contentEntityManager.getById(this.contentId);
    }

    public void setSpaceContentEntityObject(SpaceContentEntityObject spaceContentEntityObject) {
        this.spaceContentEntityObject = spaceContentEntityObject;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public long getContentId() {
        return this.contentId;
    }

    public void setContentId(long contentId) {
        this.contentId = contentId;
    }

    public String getType() {
        return this.getNiceContentType(this.getSpaceContentEntityObject());
    }

    public long getExistingContentId() {
        return this.existingContentId;
    }

    public void setExistingContentId(long existingContentId) {
        this.existingContentId = existingContentId;
    }

    public void setIndexer(ConfluenceIndexer indexer) {
        this.indexer = indexer;
    }
}

