/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import bucket.core.comparators.CreationDateComparator;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.BlogPostsCalendar;
import com.atlassian.confluence.pages.actions.AbstractBlogPostsAction;
import com.atlassian.core.util.DateUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;

public class ViewBlogPostsByDateAction
extends AbstractBlogPostsAction {
    private String postingDate;
    private Calendar postingDay;
    private int period = 5;
    private List blogPosts;
    private Map aggregatedBlogPosts;
    private BlogPost nextPost;
    private BlogPost previousPost;
    private BlogPost nextDatePost;
    private BlogPost previousDatePost;
    private BlogPostsCalendar calendar;

    public String execute() {
        try {
            this.postingDay = Calendar.getInstance();
            this.postingDay.setTime(new SimpleDateFormat("yyyy/MM/dd").parse(this.postingDate));
            DateUtils.toStartOfPeriod((Calendar)this.postingDay, (int)this.period);
            return "success";
        }
        catch (ParseException e) {
            this.addActionError(this.getText("date.notvalid", new String[]{this.postingDate}));
            return "error";
        }
    }

    public void validate() {
        super.validate();
        if (this.getSpace() == null) {
            this.addActionError(this.getText("space.doesnt.exist"));
        }
    }

    public BlogPostsCalendar getCalendarForThisMonth() {
        if (this.calendar == null) {
            this.calendar = new BlogPostsCalendar(this.postingDay.getTime(), this.pageManager.getBlogPosts(this.getKey(), this.postingDay, 2), this.getKey());
            this.calendar.setFirstPostInNextMonth(this.getFirstPostInNextMonth(this.postingDay));
            this.calendar.setLastPostInPreviousMonth(this.getLastPostInPreviousMonth(this.postingDay));
        }
        return this.calendar;
    }

    public List getBlogPosts() {
        if (this.blogPosts == null) {
            this.blogPosts = this.pageManager.getBlogPosts(this.getKey(), this.postingDay, this.period);
            Collections.sort(this.blogPosts, new CreationDateComparator());
            Collections.reverse(this.blogPosts);
        }
        return this.blogPosts;
    }

    public Map getAggregatedBlogPosts() {
        if (this.aggregatedBlogPosts == null) {
            this.aggregatedBlogPosts = new ListOrderedMap();
            for (BlogPost blogPost : this.getBlogPosts()) {
                List<BlogPost> temp;
                String dateString = this.getDateString(blogPost.getCreationDate());
                if (this.aggregatedBlogPosts.get(dateString) == null) {
                    temp = new ArrayList<BlogPost>();
                    temp.add(blogPost);
                    this.aggregatedBlogPosts.put(dateString, temp);
                    continue;
                }
                temp = (List)this.aggregatedBlogPosts.get(dateString);
                temp.add(blogPost);
            }
        }
        return this.aggregatedBlogPosts;
    }

    private String getDateString(Date date) {
        return DateFormat.getDateInstance(0).format(date);
    }

    public String getPostingDate() {
        return this.postingDate;
    }

    public void setPostingDate(String postingDate) {
        this.postingDate = postingDate;
    }

    public String getPostingDayOfMonth() {
        return new SimpleDateFormat("dd").format(this.postingDay.getTime());
    }

    public String getPostingYear() {
        return new SimpleDateFormat("yyyy").format(this.postingDay.getTime());
    }

    public String getPostingMonthNumeric() {
        return new SimpleDateFormat("MM").format(this.postingDay.getTime());
    }

    public String getPostingMonth() {
        return new SimpleDateFormat("MMMM").format(this.postingDay.getTime());
    }

    public BlogPost getNextPost() {
        if (this.nextPost == null) {
            if (this.getBlogPosts().size() > 0) {
                BlogPost lastPost = (BlogPost)this.getBlogPosts().get(0);
                this.nextPost = this.pageManager.findNextBlogPost(lastPost);
            } else {
                this.nextPost = this.pageManager.findNextBlogPost(this.getKey(), this.postingDay.getTime());
            }
        }
        return this.nextPost;
    }

    public BlogPost getNextDatePost() {
        if (this.nextDatePost == null && this.getNextPost() != null) {
            this.nextDatePost = this.getNextPost();
            while (this.compareToPostingDay(this.nextDatePost.getCreationDate())) {
                BlogPost temp = this.pageManager.findNextBlogPost(this.nextDatePost);
                if (temp != null && temp != this.nextDatePost) {
                    this.nextDatePost = temp;
                    continue;
                }
                this.nextDatePost = null;
                break;
            }
        }
        return this.nextDatePost;
    }

    public BlogPost getPreviousPost() {
        if (this.previousPost == null) {
            int blogPostsSize = this.getBlogPosts().size();
            if (blogPostsSize > 0) {
                BlogPost firstPost = (BlogPost)this.getBlogPosts().get(blogPostsSize - 1);
                this.previousPost = this.pageManager.findPreviousBlogPost(firstPost);
            } else {
                this.previousPost = this.pageManager.findPreviousBlogPost(this.getKey(), this.postingDay.getTime());
            }
        }
        return this.previousPost;
    }

    public BlogPost getPreviousDatePost() {
        if (this.previousDatePost == null && this.getPreviousPost() != null) {
            this.previousDatePost = this.getPreviousPost();
            while (this.compareToPostingDay(this.previousDatePost.getCreationDate())) {
                BlogPost temp = this.pageManager.findPreviousBlogPost(this.previousDatePost);
                if (temp != null && temp != this.previousDatePost) {
                    this.previousDatePost = temp;
                    continue;
                }
                this.previousDatePost = null;
                break;
            }
        }
        return this.previousDatePost;
    }

    private boolean compareToPostingDay(Date date) {
        Calendar cal = BlogPost.toCalendar(date);
        return this.postingDay.get(1) == cal.get(1) && this.postingDay.get(2) == cal.get(2) && this.postingDay.get(5) == cal.get(5);
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public String getFormattedDateRangeDescription() {
        if (this.period == 5) {
            return this.getDateFormatter().formatServerDate(this.postingDay.getTime());
        }
        return new SimpleDateFormat("MMMMMMMMM, yyyy").format(this.postingDay.getTime());
    }
}

