/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostViewEvent;
import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.confluence.links.ReferralManager;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.BlogPostsCalendar;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.AbstractPageAction;
import com.atlassian.confluence.pages.actions.CommentAware;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.CaptchaManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.ConfluenceTrackbackUtils;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.core.util.DateUtils;
import com.atlassian.event.Event;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.links.Link;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ViewPageAction
extends AbstractPageAction
implements PageAware,
CommentAware {
    private static final Logger log = Logger.getLogger(ViewPageAction.class);
    public static final int HOT_REFERRERS_COUNT = 10;
    protected ReferralManager referralManager;
    protected NotificationManager notificationManager;
    protected CommentManager commentManager;
    private CaptchaManager captchaManager;
    private ConfluenceTrackbackUtils trackbackUtils;
    protected WikiStyleRenderer wikiStyleRenderer;
    private String pageContent;
    private List hotReferrers;
    private List externalReferences;
    private Map xHtmlComments;
    private String pageXHtmlContent;
    private List possibleAlternativesInSpace;
    private List possibleAlternativesElsewhere;
    private long replyToComment;
    private BlogPostsCalendar calendar;
    private boolean showCommentArea = false;
    private boolean editComment = false;
    private BlogPost lastPostInPreviousMonth;
    private BlogPost firstPostInNextMonth;
    private boolean navigatingVersions;
    private Comment comment;
    private long rootCommentId;
    private Comment rootComment;
    private long focusedCommentId;

    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public void setReferralManager(ReferralManager referralManager) {
        this.referralManager = referralManager;
    }

    public void setPageContent(String pageContent) {
        this.pageContent = pageContent;
    }

    public String getPageContent() {
        return this.pageContent;
    }

    public List getHotReferrers() {
        if (this.hotReferrers == null && !this.getGlobalSettings().getReferrerSettings().isHideExternalReferrers()) {
            this.hotReferrers = this.referralManager.getHotReferrers(this.getPage(), 10);
        }
        return this.hotReferrers;
    }

    public List getExternalReferences() {
        return this.externalReferences;
    }

    public boolean isPageRequired() {
        return true;
    }

    public boolean isLatestVersionRequired() {
        return false;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public String execute() throws Exception {
        if (this.getPage() != null && this.getPage().getSpace() == null && this.getPage().isLatestVersion()) {
            this.addActionError(this.getText("error.corrupt.page", new Object[]{"" + this.getPage().getId(), this.getPage().getContent()}));
            return "error";
        }
        this.pageContent = this.getPage().getContent();
        PageContext context = this.getPage().toPageContext();
        this.pageXHtmlContent = this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)context, this.getPage().getContent());
        this.externalReferences = context.getExternalReferences();
        this.addToHistory(this.getPage());
        if (this.focusedCommentId != 0L && this.isThreadComments()) {
            this.focusOnComment(this.findCommentInPage(this.focusedCommentId));
        }
        if (this.focusedCommentId != 0L || this.rootCommentId != 0L || this.comment != null) {
            this.setShowComments(Boolean.TRUE);
        }
        if (this.getPage() instanceof Page) {
            this.eventManager.publishEvent((Event)new PageViewEvent(this, (Page)this.getPage()));
        } else if (this.getPage() instanceof BlogPost) {
            this.eventManager.publishEvent((Event)new BlogPostViewEvent(this, (BlogPost)this.getPage()));
        }
        return this.getPage().getType();
    }

    @HtmlSafe
    public String getPageXHtmlContent() {
        return this.pageXHtmlContent;
    }

    @HtmlSafe
    public Map getXHtmlComments() {
        if (this.xHtmlComments == null) {
            this.xHtmlComments = new HashMap();
            for (Comment comment : this.getPage().getComments()) {
                this.xHtmlComments.put(comment, this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)comment.toPageContext(), comment.getContent()));
            }
        }
        return this.xHtmlComments;
    }

    public Boolean getCommentsShowing() {
        return this.getUserInterfaceState().getCommentsShowing();
    }

    public void setShowComments(Boolean showComments) {
        this.getUserInterfaceState().setCommentsShowing(showComments);
    }

    public Boolean getChildrenShowing() {
        return this.getUserInterfaceState().getChildrenShowing();
    }

    public void setShowChildren(Boolean showChildren) {
        this.getUserInterfaceState().setChildrenShowing(showChildren);
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public boolean isThreadComments() {
        return this.settingsManager.getGlobalSettings().isAllowThreadedComments();
    }

    public List getPossibleAlternativesInSpace() {
        if (this.getSpace() == null || this.getTitle() == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.possibleAlternativesInSpace == null) {
            this.possibleAlternativesInSpace = this.pageManager.getPossibleRedirectsForSpace(this.getSpace(), this.getTitle());
        }
        return this.possibleAlternativesInSpace;
    }

    public List getPossibleAlternativesElsewhere() {
        if (this.getTitle() == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.possibleAlternativesElsewhere == null) {
            this.possibleAlternativesElsewhere = this.getPermittedEntitiesOf(this.pageManager.getPossibleRedirects(this.getTitle()));
            if (this.getSpace() != null) {
                Iterator it = this.possibleAlternativesElsewhere.iterator();
                while (it.hasNext()) {
                    AbstractPage page = (AbstractPage)it.next();
                    if (!page.getSpace().equals(this.getSpace())) continue;
                    it.remove();
                }
            }
        }
        return this.possibleAlternativesElsewhere;
    }

    public boolean isUserWatchingPage() {
        if (this.isAnonymousUser() || this.getPage() == null) {
            return false;
        }
        try {
            return this.notificationManager.getNotificationByUserAndPage(this.getRemoteUser(), this.getPage()) != null;
        }
        catch (Exception e) {
            log.error((Object)"Error finding if user is watching page", (Throwable)e);
            return false;
        }
    }

    public boolean isUserWatchingSpace() {
        if (this.isAnonymousUser() || this.getPage() == null) {
            return false;
        }
        Space space = this.getPage().getOriginalVersionPage() != null ? this.getPage().getOriginalVersionPage().getSpace() : this.getPage().getSpace();
        return this.notificationManager.getNotificationByUserAndSpace(this.getRemoteUser(), space.getKey()) != null;
    }

    public ConfluenceTrackbackUtils getTrackbackUtils() {
        if (this.trackbackUtils == null) {
            this.trackbackUtils = new ConfluenceTrackbackUtils();
        }
        return this.trackbackUtils;
    }

    public String getDateString(Date date) {
        return this.getDateFormatter().formatDateFull(date);
    }

    public boolean isAttachmentsInWebDavFolder() {
        return this.getAttachmentsWebDavUrl() != null;
    }

    public String getAttachmentsWebDavUrl() {
        return this.settingsManager.getGlobalSettings().getWebdavServerUrl();
    }

    public String getAttachmentsWebDavUrlForPage() {
        String serverUrl = this.getAttachmentsWebDavUrl();
        if (!serverUrl.endsWith("/")) {
            serverUrl = serverUrl + "/";
        }
        return serverUrl + this.getPage().getIdAsString() + "/";
    }

    public String renderLink(String link) {
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)this.getPage().toPageContext(), "[" + link + "]");
    }

    public String renderExternalLink(Link link) {
        String linkBody;
        String extLink = linkBody = link.getLinkBody();
        if (linkBody.indexOf("<") < 0) {
            extLink = GeneralUtil.displayShortUrl(linkBody);
        }
        return "<a href=\"" + link.getUrl() + "\" title=\"" + link.getTitle() + "\">" + extLink + "</a>";
    }

    public long getReplyToComment() {
        return this.replyToComment;
    }

    public void setReplyToComment(long replyToComment) {
        this.replyToComment = replyToComment;
        this.focusedCommentId = replyToComment;
    }

    public Comment getRootComment() {
        if (this.rootComment == null && this.rootCommentId != 0L) {
            this.rootComment = this.findCommentInPage(this.rootCommentId);
        }
        return this.rootComment;
    }

    public void setRootCommentId(long rootCommentId) {
        this.rootCommentId = rootCommentId;
    }

    public void setFocusedCommentId(long focusedCommentId) {
        if (this.replyToComment == 0L) {
            this.focusedCommentId = focusedCommentId;
        }
    }

    private void focusOnComment(Comment focusedComment) {
        if (focusedComment != null && focusedComment.getDepth() >= 4) {
            this.rootComment = focusedComment.getParent();
            if (this.rootComment.getDescendantsCount() < 10) {
                this.rootComment = this.rootComment.getParent();
            }
        }
    }

    private Comment findCommentInPage(long commentId) {
        Comment myComment = null;
        for (Comment comment : this.getPage().getComments()) {
            if (comment.getId() != commentId) continue;
            myComment = comment;
            break;
        }
        return myComment;
    }

    public long getFocusedCommentId() {
        return this.focusedCommentId;
    }

    public BlogPostsCalendar getCalendarForThisMonth() {
        if (this.calendar == null && this.getPage() instanceof BlogPost) {
            BlogPost post = (BlogPost)this.getPage();
            Calendar cal = Calendar.getInstance();
            cal.setTime(post.getCreationDate());
            this.calendar = new BlogPostsCalendar(post.getCreationDate(), this.pageManager.getBlogPosts(this.getSpaceKey(), cal, 2), this.getSpaceKey());
            this.calendar.setFirstPostInNextMonth(this.getFirstPostInNextMonth(cal));
            this.calendar.setLastPostInPreviousMonth(this.getLastPostInPreviousMonth(cal));
        }
        return this.calendar;
    }

    public BlogPost getFirstPostInNextMonth(Calendar postingDate) {
        if (this.firstPostInNextMonth == null) {
            Calendar postDate = (Calendar)postingDate.clone();
            DateUtils.toEndOfPeriod((Calendar)postDate, (int)2);
            this.firstPostInNextMonth = this.pageManager.findNextBlogPost(this.getSpaceKey(), postDate.getTime());
        }
        return this.firstPostInNextMonth;
    }

    public BlogPost getLastPostInPreviousMonth(Calendar postingDate) {
        if (this.lastPostInPreviousMonth == null) {
            Calendar postDate = (Calendar)postingDate.clone();
            DateUtils.toStartOfPeriod((Calendar)postDate, (int)2);
            this.lastPostInPreviousMonth = this.pageManager.findPreviousBlogPost(this.getSpaceKey(), postDate.getTime());
        }
        return this.lastPostInPreviousMonth;
    }

    public List getInheritedContentPermissions() {
        return this.contentPermissionManager.getInheritedContentPermissions(this.getPage());
    }

    public long getPageIdOfVersionBefore(AbstractPage page) {
        ContentEntityObject entity = this.pageManager.getPreviousVersion(page);
        return entity == null ? -1L : entity.getId();
    }

    public long getPageIdOfVersionAfter(AbstractPage page) {
        ContentEntityObject entity = this.pageManager.getNextVersion(page);
        return entity == null ? -1L : entity.getId();
    }

    public boolean hasPreviousVersion(AbstractPage page) {
        try {
            return this.getPageIdOfVersionBefore(page) > 0L;
        }
        catch (Exception e) {
            log.error((Object)("Error retrieving version of page previous to: " + page), (Throwable)e);
            return false;
        }
    }

    public boolean hasNextVersion(AbstractPage page) {
        try {
            return this.getPageIdOfVersionAfter(page) > 0L;
        }
        catch (Exception e) {
            log.error((Object)("Error retrieving version of page after: " + page), (Throwable)e);
            return false;
        }
    }

    public boolean isShowCommentArea() {
        return this.showCommentArea;
    }

    public void setShowCommentArea(boolean showCommentArea) {
        this.showCommentArea = showCommentArea;
    }

    public boolean isEditComment() {
        return this.editComment;
    }

    public void setEditComment(boolean editComment) {
        this.editComment = editComment;
    }

    public boolean isFavouritePage() {
        if (this.isAnonymousUser()) {
            return false;
        }
        return this.getPage().isFavourite(this.getRemoteUser());
    }

    public boolean isNavigatingVersions() {
        return this.navigatingVersions;
    }

    public void setNavigatingVersions(boolean navigatingVersions) {
        this.navigatingVersions = navigatingVersions;
    }

    public void setCommentManager(CommentManager commentManager) {
        this.commentManager = commentManager;
    }

    @HtmlSafe
    public String getCommentAsXHtmlForWysiwyg() {
        return this.wysiwygConverter.convertWikiMarkupToXHtml(this.getPage(), this.getComment().getContent());
    }

    public WebInterfaceContext getWebInterfaceContext() {
        DefaultWebInterfaceContext result = new DefaultWebInterfaceContext(super.getWebInterfaceContext());
        if (this.getClass().equals(ViewPageAction.class)) {
            result.setParameter("viewMode", Boolean.TRUE);
        }
        return result;
    }

    public WebInterfaceContext getWebInterfaceContext(Comment comment) {
        DefaultWebInterfaceContext result = new DefaultWebInterfaceContext(this.getWebInterfaceContext());
        result.setComment(comment);
        return result;
    }

    public CaptchaManager getCaptchaManager() {
        return this.captchaManager;
    }

    public void setCaptchaManager(CaptchaManager captchaManager) {
        this.captchaManager = captchaManager;
    }

    public boolean isPermitted() {
        return GeneralUtil.isSuperUser(this.getRemoteUser()) || this.permissionManager.hasPermission(this.getRemoteUser(), Permission.VIEW, this.getPage().getLatestVersion());
    }
}

