/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions.beans;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.UploadedResource;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.FileUploadManager;
import com.atlassian.confluence.util.AttachFileHelper;
import com.atlassian.xwork.FileUploadUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentStorer {
    private FileUploadManager fileUploadManager;
    private AttachmentManager attachmentManager;
    private List<String> getFilenamesSuccessfullyAttached = new ArrayList<String>();
    private AttachFileHelper attachFileHelper;

    public AttachmentStorer(AttachFileHelper aFHelper) {
        this.attachFileHelper = aFHelper;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setFileUploadManager(FileUploadManager fileUploadManager) {
        this.fileUploadManager = fileUploadManager;
    }

    public List<Attachment> attachFiles(ContentEntityObject contentEntityObject) {
        ArrayList<Attachment> attachmentsAdded = new ArrayList<Attachment>();
        for (FileUploadUtils.UploadedFile uploadedFile : this.attachFileHelper.getUploadedFiles()) {
            String uploadedFilename = uploadedFile.getFileName();
            UploadedResource uploadedResource = new UploadedResource(uploadedFile);
            this.fileUploadManager.storeResource(uploadedResource, this.attachFileHelper.getCommentForFilename(uploadedFilename), contentEntityObject);
            Attachment attachment = this.attachmentManager.getAttachment(contentEntityObject, uploadedFilename);
            attachmentsAdded.add(attachment);
            this.getFilenamesSuccessfullyAttached.add(attachment.getFileName());
        }
        return attachmentsAdded;
    }

    public List<String> getGetFilenamesSuccessfullyAttached() {
        return this.getFilenamesSuccessfullyAttached;
    }
}

