/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions.beans;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.links.LinkManager;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageIncomingLinks {
    private final LinkManager linkManager;
    private final PermissionManager permissionManager;

    public PageIncomingLinks(LinkManager linkManager, PermissionManager permissionManager) {
        this.linkManager = linkManager;
        this.permissionManager = permissionManager;
    }

    public List<OutgoingLink> getIncomingLinks(AbstractPage page, User user) {
        List allLinks = this.linkManager.getIncomingLinksToContent(page);
        allLinks = this.permissionManager.getPermittedEntities(user, Permission.VIEW, allLinks);
        List<OutgoingLink> incomingLinks = this.getUniqueIncomingLinks(page, allLinks);
        return incomingLinks;
    }

    private List<OutgoingLink> getUniqueIncomingLinks(AbstractPage page, List<OutgoingLink> allLinks) {
        ArrayList<OutgoingLink> incomingLinks = new ArrayList<OutgoingLink>();
        HashSet<ContentEntityObject> sourceContentPages = new HashSet<ContentEntityObject>();
        for (OutgoingLink link : allLinks) {
            if (link.isFrom(page) || !sourceContentPages.add(link.getSourceContent())) continue;
            incomingLinks.add(link);
        }
        return incomingLinks;
    }
}

