/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions.beans;

import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.user.User;
import java.util.List;

public class SuggestedLabels {
    private final LabelManager labelManager;

    public SuggestedLabels(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public List getSuggestedLabelsForPage(AbstractPage page, User user) {
        String username = this.getUsernameForUser(user);
        return LabelUtil.getRecentAndPopularLabelsForEntity(page, this.labelManager, 20, username);
    }

    public List getSuggestedLabelsForSpace(String spaceKey, User user) {
        String username = this.getUsernameForUser(user);
        return LabelUtil.getRecentAndPopularLabels(spaceKey, this.labelManager, 20, username);
    }

    private String getUsernameForUser(User user) {
        return user == null ? null : user.getName();
    }
}

