/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.persistence.dao;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentDataNotFoundException;
import com.atlassian.confluence.pages.persistence.dao.FileLocationResolver;
import com.atlassian.confluence.pages.persistence.dao.NonTransactionalAttachmentDataDao;
import com.atlassian.core.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Category;

public class FileSystemAttachmentDataDao
implements NonTransactionalAttachmentDataDao {
    protected static Category log = Category.getInstance(FileSystemAttachmentDataDao.class);
    protected FileLocationResolver attachmentsDirResolver;
    private static final String REASON_DIR_DOES_NOT_EXIST = "Directory does not exist";
    private static final String REASON_NOT_A_DIRECTORY = "Not a directory";
    private static final String REASON_NOT_EMPTY = "Not empty";
    private static final String REASON_NOT_WRITABLE = "Not writable";
    private static final String REASON_UNKNOWN = "Unknown reason";
    private static final String ATTACHMENT_BACKUP_DATE_FORMAT = "yyyyMMddHHmmss";
    public static final FileSystemAttachmentNamingStrategy NAMING_STRATEGY_ID = new AttachmentIdNamingStrategy();
    public static final FileSystemAttachmentNamingStrategy NAMING_STRATEGY_FILE_NAME = new AttachmentFileNameNamingStrategy();
    private FileSystemAttachmentNamingStrategy namingStrategy = NAMING_STRATEGY_ID;

    public FileSystemAttachmentNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(FileSystemAttachmentNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    protected File getConfluenceAttachmentDirectory() {
        return this.attachmentsDirResolver.getFileLocation();
    }

    protected File getLatestAttachmentFile(Attachment attachment) {
        File attachmentbase = this.getDirectoryForAttachment(attachment.getContent(), attachment);
        if (attachmentbase.isDirectory()) {
            attachmentbase = new File(attachmentbase, Integer.toString(attachment.getVersion()));
        }
        return attachmentbase;
    }

    public InputStream getDataForAttachment(Attachment attachment) throws AttachmentDataNotFoundException {
        if (attachment == null) {
            throw new IllegalArgumentException("The attachment cannot be null.");
        }
        try {
            return new FileInputStream(this.getLatestAttachmentFile(attachment));
        }
        catch (IOException ex) {
            throw new AttachmentDataNotFoundException("Problem while getting attachment stream (" + attachment + ") from file system", ex);
        }
    }

    public void removeDataForAttachment(Attachment attachment, ContentEntityObject originalContent) {
        if (attachment == null) {
            throw new IllegalArgumentException("The attachment cannot be null.");
        }
        if (originalContent == null) {
            throw new IllegalArgumentException("The content cannot be null.");
        }
        File attachmentFolder = this.getDirectoryForAttachment(originalContent, attachment);
        if (!attachmentFolder.exists()) {
            log.error((Object)("Could not find attachments to remove at '" + attachmentFolder.getAbsolutePath() + "'"));
        } else if (!FileUtils.deleteDir((File)attachmentFolder)) {
            log.error((Object)("Error removing the attachments folder for the page with id: " + originalContent.getId() + " folder: " + attachmentFolder.getAbsolutePath() + " " + FileSystemAttachmentDataDao.getDeleteErrorReason(attachmentFolder)));
        }
    }

    public void saveDataForAttachment(Attachment attachment, InputStream data) {
        this.saveDataForAttachment(attachment, data, false);
    }

    public FileLocationResolver getAttachmentsDirResolver() {
        return this.attachmentsDirResolver;
    }

    protected void saveDataForAttachment(Attachment attachment, InputStream data, boolean overwrite) {
        if (attachment == null) {
            throw new IllegalArgumentException("The attachment cannot be null");
        }
        if (data == null) {
            throw new IllegalArgumentException("The data to be written cannot be null.");
        }
        File parentFolder = this.getDirectoryForAttachment(attachment.getContent(), attachment);
        if (!parentFolder.exists()) {
            parentFolder.mkdirs();
        }
        File destFile = new File(parentFolder, Integer.toString(attachment.getVersion()));
        try {
            FileUtils.copyFile((InputStream)data, (File)destFile, (boolean)overwrite);
        }
        catch (IOException e) {
            log.error((Object)("Error writing '" + destFile + "' to disk."), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void saveDataForAttachmentVersion(Attachment attachment, Attachment previousVersion, InputStream data) {
        this.saveDataForAttachment(attachment, data);
    }

    public void replaceDataForAttachment(Attachment attachment, InputStream data) {
        this.saveDataForAttachment(attachment, data, true);
    }

    public void moveAttachment(Attachment attachment, Attachment oldAttachment, ContentEntityObject newContent) {
        if (attachment == null) {
            throw new IllegalArgumentException("The attachment cannot be null.");
        }
        if (oldAttachment == null) {
            throw new IllegalArgumentException("The old attachment cannot be null.");
        }
        if (newContent == null) {
            throw new IllegalArgumentException("The new content object of the attachment cannot be null.");
        }
        File originalAttachmentFolder = this.getDirectoryForAttachment(oldAttachment.getContent(), oldAttachment);
        File newAttachmentFolder = this.getDirectoryForAttachment(newContent, attachment);
        FileUtils.moveDir((File)originalAttachmentFolder, (File)newAttachmentFolder);
    }

    protected File getDirectoryForAttachment(ContentEntityObject content, Attachment attachment) {
        Attachment latestVersion = (Attachment)attachment.getLatestVersion();
        return new File(this.getDirectoryForContent(content), this.namingStrategy.getAttachmentFileName(attachment));
    }

    protected File getDirectoryForContent(ContentEntityObject content) {
        return new File(this.getConfluenceAttachmentDirectory(), String.valueOf(content.getId()));
    }

    public void prepareForMigrationTo() {
        File attachmentsDirFile = this.getConfluenceAttachmentDirectory();
        if (!attachmentsDirFile.exists()) {
            log.info((Object)("Creating attachments directory on the filesystem at '" + attachmentsDirFile.getAbsolutePath() + "'"));
            attachmentsDirFile.mkdirs();
            return;
        }
        Date now = new Date();
        SimpleDateFormat isoFormat = new SimpleDateFormat(ATTACHMENT_BACKUP_DATE_FORMAT);
        File attachmentsBackupDir = new File(attachmentsDirFile, "attachment-backup-" + isoFormat.format(now));
        attachmentsBackupDir.mkdirs();
        File[] fileList = attachmentsDirFile.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            File file = fileList[i];
            File newLocation = new File(attachmentsBackupDir, file.getName());
            FileUtils.moveDir((File)file, (File)newLocation);
        }
    }

    public void afterMigrationFrom() {
    }

    private static String getDeleteErrorReason(File attachmentFolderForThisPage) {
        if (!attachmentFolderForThisPage.exists()) {
            return REASON_DIR_DOES_NOT_EXIST;
        }
        if (!attachmentFolderForThisPage.isDirectory()) {
            return REASON_NOT_A_DIRECTORY;
        }
        if (attachmentFolderForThisPage.listFiles().length > 2) {
            return REASON_NOT_EMPTY;
        }
        if (attachmentFolderForThisPage.canWrite()) {
            return REASON_NOT_WRITABLE;
        }
        return REASON_UNKNOWN;
    }

    public void setAttachmentsDirResolver(FileLocationResolver attachmentsDirResolver) {
        this.attachmentsDirResolver = attachmentsDirResolver;
    }

    private static class AttachmentFileNameNamingStrategy
    implements FileSystemAttachmentNamingStrategy {
        private AttachmentFileNameNamingStrategy() {
        }

        public String getAttachmentFileName(Attachment attachment) {
            return attachment.getFileName();
        }
    }

    private static class AttachmentIdNamingStrategy
    implements FileSystemAttachmentNamingStrategy {
        private AttachmentIdNamingStrategy() {
        }

        public String getAttachmentFileName(Attachment attachment) {
            return String.valueOf(((Attachment)attachment.getLatestVersion()).getId());
        }
    }

    public static interface FileSystemAttachmentNamingStrategy {
        public String getAttachmentFileName(Attachment var1);
    }
}

