/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.persistence.dao;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.persistence.dao.AbstractAttachmentCopier;
import com.atlassian.confluence.pages.persistence.dao.AttachmentDao;
import com.atlassian.confluence.util.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;

public class GeneralAttachmentCopier
extends AbstractAttachmentCopier
implements AttachmentDao.AttachmentCopier {
    protected static Category log = Category.getInstance(GeneralAttachmentCopier.class);
    protected AttachmentManager sourceAttachmentManager;
    protected AttachmentManager destinationAttachmentManager;

    public GeneralAttachmentCopier(AttachmentManager sourceAttachmentManager, AttachmentManager destinationAttachmentManager) {
        this.sourceAttachmentManager = sourceAttachmentManager;
        this.destinationAttachmentManager = destinationAttachmentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Beginning copy from '" + this.sourceAttachmentManager + "' to '" + this.destinationAttachmentManager + "'"));
        }
        if (this.progress != null) {
            this.progress.setStatus("Finding Attachments");
        }
        List sourceAttachments = this.sourceAttachmentManager.getAttachmentDao().findAll();
        int totalAttachments = sourceAttachments.size();
        int currentAttachmentIndex = 0;
        if (log.isInfoEnabled()) {
            log.info((Object)("Found " + totalAttachments + " to copy"));
        }
        if (this.progress != null) {
            this.progress.setTotalObjects(totalAttachments);
            this.progress.setStatus("Copying attachments");
        }
        for (Attachment attachment : sourceAttachments) {
            if (attachment.getContent() == null) {
                log.error((Object)("Attachment '" + attachment + "' does not have a content object. Skipping."));
                ++currentAttachmentIndex;
                continue;
            }
            if (!this.isContentSpaceIncluded(attachment.getContent())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Skipping attachment '" + attachment + "' since its parent content '" + attachment.getContent() + "' is not in the included Space list."));
                }
                ++currentAttachmentIndex;
                continue;
            }
            if (this.isContentExcluded(attachment.getContent())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Skipping attachment '" + attachment + "' since its parent content '" + attachment.getContent() + "' is in the exclusion list."));
                }
                ++currentAttachmentIndex;
                continue;
            }
            List attachmentVersions = this.sourceAttachmentManager.getAllVersions(attachment);
            attachmentVersions.remove(0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Copying attachment '" + attachment + "' and " + attachmentVersions.size() + " previous versions."));
            }
            attachmentVersions.add(attachment);
            Iterator versionIterator = attachmentVersions.iterator();
            Attachment previousAttachmentVersion = null;
            while (versionIterator.hasNext()) {
                Attachment newVersion;
                Attachment currentSourceAttachment = (Attachment)versionIterator.next();
                Attachment currentVersion = null;
                if (previousAttachmentVersion == null) {
                    newVersion = this.constructFirstAttachmentVersion(currentSourceAttachment);
                } else {
                    newVersion = previousAttachmentVersion;
                    currentVersion = this.cloneAttachment(newVersion);
                    this.constructNewAttachmentVersion(newVersion, currentSourceAttachment);
                }
                InputStream attachmentData = null;
                try {
                    attachmentData = this.sourceAttachmentManager.getAttachmentData(newVersion);
                    if (attachmentData == null) continue;
                    this.destinationAttachmentManager.saveAttachment(newVersion, currentVersion, attachmentData);
                }
                catch (IOException e) {
                    log.error((Object)("There was a problem saving Attachment '" + newVersion + "' to a new AttachmentManager. Skipping"));
                }
                finally {
                    previousAttachmentVersion = newVersion;
                    IOUtils.close(attachmentData);
                }
            }
            if (this.progress == null) continue;
            this.progress.setCurrentCount(++currentAttachmentIndex);
            this.progress.setStatus("Copied " + currentAttachmentIndex + " out of " + totalAttachments + " attachments.");
        }
        log.info((Object)"Copy completed.");
        if (this.progress != null) {
            this.progress.setCurrentCount(totalAttachments);
            this.progress.setStatus("Completed - " + totalAttachments + " attachments transferred.");
        }
    }

    private void constructNewAttachmentVersion(Attachment newAttachment, Attachment currentAttachment) {
        newAttachment.setComment(currentAttachment.getComment());
        newAttachment.setContentType(currentAttachment.getContentType());
        newAttachment.setFileName(currentAttachment.getFileName());
        newAttachment.setFileSize(currentAttachment.getFileSize());
        newAttachment.setLastModificationDate(currentAttachment.getLastModificationDate());
        newAttachment.setLastModifierName(currentAttachment.getLastModifierName());
        ContentEntityObject ceo = currentAttachment.getContent();
        newAttachment.setContent(ceo);
    }

    private Attachment constructFirstAttachmentVersion(Attachment attachment) {
        Attachment newVersion = this.cloneAttachment(attachment);
        newVersion.setOriginalVersion(null);
        return newVersion;
    }

    private Attachment cloneAttachment(Attachment attachment) {
        Attachment newVersion;
        try {
            newVersion = (Attachment)attachment.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("There was a problem cloning an Attachment object: ", e);
        }
        return newVersion;
    }
}

