/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.persistence.dao;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ListQuery;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentDataNotFoundException;
import com.atlassian.confluence.pages.persistence.dao.AttachmentDao;
import com.atlassian.confluence.pages.persistence.dao.WebDavConfiguration;
import com.atlassian.confluence.util.GeneralUtil;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.log4j.Category;
import org.apache.webdav.lib.Property;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.WebdavResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDavAttachmentDao
implements AttachmentDao {
    private ContentEntityManager contentEntityManager;
    private WebDavConfiguration config;
    private static Category log = Category.getInstance(WebDavAttachmentDao.class);
    private static final String PROP_COMMENT = "confluenceComment";
    private static final String PROP_MODIFIER = "confluenceModifier";

    public void setConfig(WebDavConfiguration config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Attachment> getLatestVersionsOfAttachments(ContentEntityObject ceo) {
        WebdavResource wdr;
        String path = this.getAttachmentParentPath(ceo);
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        try {
            wdr = this.connect(path);
        }
        catch (IOException e) {
            log.debug((Object)"getLatestVersionsOfAttachments connect failed", (Throwable)e);
            return attachments;
        }
        try {
            attachments.addAll(this.constructAttachmentFromPath(wdr, ceo));
        }
        catch (Exception e) {
            log.error((Object)("Failure in getting the latest versions of Attachments for content '" + ceo + "'."), (Throwable)e);
        }
        finally {
            this.disconnect(wdr);
        }
        return attachments;
    }

    private List<Attachment> constructAttachmentFromPath(WebdavResource wdr, ContentEntityObject ceo) throws IOException {
        WebdavResource[] attachmentsOfPageWdrs;
        LinkedList<Attachment> attachments = new LinkedList<Attachment>();
        for (WebdavResource attachmentWdr : attachmentsOfPageWdrs = wdr.listWebdavResources()) {
            if (attachmentWdr.isCollection()) continue;
            this.copyCredentialsToWdr(wdr, attachmentWdr);
            Attachment attachment = this.createAttachmentObject(ceo, attachmentWdr, null);
            attachments.add(attachment);
            String attachmentPath = attachmentWdr.getPath();
            HttpURL httpUrl = this.uriToHttpURL(attachmentPath);
            List pathsToHistoricalVersions = this.reportPathsToHistoricalVersions(attachmentWdr, httpUrl);
            if (pathsToHistoricalVersions == null) continue;
            attachment.setVersion(pathsToHistoricalVersions.size());
        }
        return attachments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List findAll() {
        WebdavResource wdr;
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        try {
            wdr = this.connect();
        }
        catch (IOException e) {
            log.debug((Object)"findAll connect failed", (Throwable)e);
            return attachments;
        }
        try {
            WebdavResource[] contentWdrs = wdr.listWebdavResources();
            for (int i = 0; i < contentWdrs.length; ++i) {
                WebdavResource contentWdr = contentWdrs[i];
                this.copyCredentialsToWdr(wdr, contentWdr);
                String contentId = contentWdr.getName();
                ContentEntityObject content = this.contentEntityManager.getById(Long.parseLong(contentId));
                if (content == null) {
                    log.info((Object)("No ContentEntityObject found for ID '" + contentId + "'. Skipping."));
                    continue;
                }
                attachments.addAll(this.constructAttachmentFromPath(contentWdr, content));
            }
        }
        catch (Exception e) {
            log.error((Object)"getAttachmentData failed", (Throwable)e);
        }
        finally {
            this.disconnect(wdr);
        }
        return attachments;
    }

    @Override
    public Iterator findLatestVersionsIterator() {
        return this.findAll().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAttachmentData(Attachment attachment) throws AttachmentDataNotFoundException {
        InputStream in = null;
        WebdavResource wdr = null;
        try {
            wdr = this.connect();
            String path = this.getAttachmentPathOfHistoricalVersion(attachment);
            HttpURL httpUrl = this.uriToHttpURL(path);
            String pathToHistoricalVersion = this.reportPathToHistoricalVersions(wdr, httpUrl, attachment.getVersion());
            if (pathToHistoricalVersion == null) {
                throw new AttachmentDataNotFoundException("Attachment '" + attachment + "' not found in WebDAV resource.");
            }
            in = this.getDataFromPath(pathToHistoricalVersion, wdr);
        }
        catch (Exception e) {
            log.error((Object)"getAttachmentData failed", (Throwable)e);
        }
        finally {
            this.disconnect(wdr);
        }
        return in;
    }

    @Override
    public List getAttachmentByQuery(ListQuery query, int firstResult) {
        throw new UnsupportedOperationException("WebDAV currently does not support searching by query.");
    }

    @Override
    public void saveNewAttachment(Attachment attachment, InputStream attachmentData) {
        WebdavResource wdr = null;
        try {
            wdr = this.connect();
            String parentPath = this.getAttachmentParentPath(attachment);
            String path = this.getAttachmentPath(attachment, null);
            wdr.mkcolMethod(parentPath);
            if (this.put(wdr, path, attachmentData) && this.setProperties(wdr, path, attachment.getComment(), attachment.getLastModifierName())) {
                attachment.getContent().removeAttachment(attachment);
                log.info((Object)("Saved attachment successfully to path: " + path));
            } else {
                log.info((Object)("PUT method returned false when trying to save attachment to path: " + path));
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed to save attachment successfully: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.disconnect(wdr);
        }
    }

    @Override
    public void saveNewAttachmentVersion(Attachment attachment, Attachment previousVersion, InputStream attachmentData) {
        WebdavResource wdr = null;
        try {
            wdr = this.connect();
            String parentPath = this.getAttachmentParentPath(attachment);
            String path = this.getAttachmentPath(attachment, null);
            wdr.mkcolMethod(parentPath);
            if (this.versioncontrol(wdr, path) && this.checkout(wdr, path) && this.put(wdr, path, attachmentData) && this.setProperties(wdr, path, attachment.getComment(), attachment.getLastModifierName()) && this.checkin(wdr, path)) {
                attachment.getContent().removeAttachment(attachment);
                log.info((Object)("Saved attachment successfully to path: " + path));
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed to save attachment successfully: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.disconnect(wdr);
        }
    }

    @Override
    public void moveAttachment(Attachment attachment, Attachment oldAttachment, ContentEntityObject newContent) {
        WebdavResource wdr = null;
        try {
            wdr = this.connect();
            String oldAttachmentPath = this.getAttachmentPath(oldAttachment, null);
            String newAttachmentPath = this.getAttachmentPath(attachment, null);
            wdr.mkcolMethod(this.getAttachmentParentPath(attachment));
            boolean result = wdr.moveMethod(oldAttachmentPath, newAttachmentPath);
            if (!result) {
                log.error((Object)("There was a problem moving attachment '" + oldAttachment + "' to '" + attachment + "'."));
            }
            this.setProperties(wdr, newAttachmentPath, attachment.getComment(), attachment.getLastModifierName());
        }
        catch (IOException e) {
            log.error((Object)"moveAttachment failed", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.disconnect(wdr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttachmentFromServer(Attachment attachment) {
        WebdavResource wdr;
        block6: {
            wdr = null;
            String path = this.getAttachmentPath(attachment, null);
            wdr = this.connect(path);
            if (wdr.exists()) break block6;
            log.info((Object)("No such file or directory for deletion at path '" + path + "'"));
            this.disconnect(wdr);
            return;
        }
        try {
            if (wdr.deleteMethod()) {
                // empty if block
            }
            this.disconnect(wdr);
        }
        catch (Exception e) {
            try {
                log.error((Object)"removeAttachmentFromServer failed", (Throwable)e);
                this.disconnect(wdr);
            }
            catch (Throwable throwable) {
                this.disconnect(wdr);
                throw throwable;
            }
        }
    }

    @Override
    public void replaceAttachmentData(Attachment attachment, InputStream attachmentData) {
        this.saveNewAttachmentVersion(attachment, null, attachmentData);
    }

    @Override
    public AttachmentDao.AttachmentMigrator getMigrator(AttachmentDao destinationDao) {
        throw new UnsupportedOperationException("WebDAV Attachment DAO does not support migrating at the DAO level.");
    }

    @Override
    public AttachmentDao.AttachmentCopier getCopier(AttachmentDao destinationDao) {
        throw new UnsupportedOperationException("WebDAV Attachment DAO does not support copying at the DAO level.");
    }

    @Override
    public void prepareForMigrationTo() {
    }

    @Override
    public void afterMigrationFrom() {
    }

    private InputStream getDataFromPath(String path, WebdavResource wdr) throws IOException {
        try {
            WebdavResource targetResource = new WebdavResource(wdr.getHttpURL(), path);
            final long bytesAvailable = targetResource.getGetContentLength();
            if (log.isDebugEnabled()) {
                log.debug((Object)("targetResource has length: " + bytesAvailable));
            }
            FilterInputStream contentLengthInputStream = new FilterInputStream(wdr.getMethodData(path)){

                public int available() {
                    return (int)bytesAvailable;
                }
            };
            return contentLengthInputStream;
        }
        catch (HttpException ex) {
            throw new RuntimeException("HTTP exception while getting file", ex);
        }
    }

    private void copyCredentialsToWdr(WebdavResource authenticatedWdr, WebdavResource newWdr) throws HttpException, IOException {
        HttpURL url = authenticatedWdr.getHttpURL();
        newWdr.setUserInfo(url.getUser(), url.getPassword());
    }

    private String reportPathToHistoricalVersions(WebdavResource wdr, HttpURL httpUrl, int version) throws IOException {
        List paths = this.reportPathsToHistoricalVersions(wdr, httpUrl);
        if (paths == null) {
            return null;
        }
        if (version > paths.size()) {
            return null;
        }
        return paths.get(version - 1).toString();
    }

    private List reportPathsToHistoricalVersions(WebdavResource wdr, HttpURL httpUrl) throws IOException {
        Enumeration propertyValues = wdr.reportMethod(httpUrl, 1);
        if (!propertyValues.hasMoreElements()) {
            log.error((Object)("Failed to retrieve the path of a historical version for resource '" + wdr + "', url '" + httpUrl + "': " + wdr.getStatusMessage()));
            return null;
        }
        ArrayList paths = Collections.list(propertyValues);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reported historical path for resource '" + wdr + "', url '" + httpUrl + "': \n" + paths));
        }
        return paths;
    }

    private Attachment createAttachmentObject(ContentEntityObject content, WebdavResource attachmentWdr, String modifierName) {
        String filename = attachmentWdr.getName();
        String contentType = attachmentWdr.getGetContentType();
        long size = attachmentWdr.getGetContentLength();
        Date creationDate = new Date(attachmentWdr.getCreationDate());
        Date lastModificationDate = new Date(attachmentWdr.getGetLastModified());
        Attachment attachment = new Attachment();
        attachment.setFileName(filename);
        attachment.setContentType(contentType);
        attachment.setFileSize(size);
        attachment.setCreationDate(creationDate);
        attachment.setLastModificationDate(lastModificationDate);
        attachment.setVersion(1);
        attachment.setContent(content);
        String value = this.getProperty(attachmentWdr, PROP_COMMENT, null);
        attachment.setComment(value);
        if (modifierName == null && ((modifierName = this.getProperty(attachmentWdr, PROP_MODIFIER, attachmentWdr.getOwner())) == null || modifierName.trim().length() == 0)) {
            modifierName = "Anonymous";
        }
        attachment.setCreatorName(modifierName);
        attachment.setLastModifierName(modifierName);
        return attachment;
    }

    private String getProperty(WebdavResource attachmentWdr, String propertyName, String defaultValue) {
        try {
            Enumeration responses = attachmentWdr.propfindMethod(0);
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            Enumeration properties = response.getProperties();
            while (properties.hasMoreElements()) {
                Property property = (Property)properties.nextElement();
                if (!property.getName().equals(propertyName)) continue;
                return property.getPropertyAsString();
            }
        }
        catch (IOException e) {
            log.error((Object)("The property '" + propertyName + "' could not be found."));
        }
        return defaultValue;
    }

    private boolean setProperties(WebdavResource wdr, String path, String comment, String lastModifier) throws IOException {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        if (comment != null) {
            properties.put(PROP_COMMENT, comment);
        } else if (log.isInfoEnabled()) {
            log.info((Object)"Attachment does not have a comment");
        }
        if (lastModifier != null) {
            properties.put(PROP_MODIFIER, lastModifier);
        } else if (log.isInfoEnabled()) {
            log.info((Object)"Attachment does not have a last modifier");
        }
        if (properties.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No properties to write for path '" + path + "'. Skipping."));
            }
            return true;
        }
        if (!wdr.proppatchMethod(path, properties, true)) {
            log.error((Object)("putMethod failed: " + wdr.getStatusMessage()));
            return false;
        }
        return true;
    }

    private boolean put(WebdavResource wdr, String path, InputStream data) throws IOException {
        if (!wdr.putMethod(path, data)) {
            log.error((Object)("Saving attachment data failed: " + wdr.getStatusMessage()));
            return false;
        }
        return true;
    }

    private WebdavResource connect() throws IOException {
        String uri = this.getWebdavServerUri();
        return this.connect(uri);
    }

    private WebdavResource connect(String uri) throws IOException {
        HttpURL httpURL = this.uriToHttpURL(uri);
        String userName = this.config.getUsername();
        String password = this.config.getPassword();
        if (userName != null) {
            httpURL.setUserinfo(userName, password);
        }
        return new WebdavResource(httpURL);
    }

    private boolean versioncontrol(WebdavResource wdr, String path) throws IOException {
        if (!wdr.versionControlMethod(path)) {
            log.error((Object)("versionControlMethod failed: " + wdr.getStatusMessage()));
            return false;
        }
        return true;
    }

    private boolean checkin(WebdavResource wdr, String path) throws IOException {
        if (!wdr.checkinMethod(path)) {
            log.error((Object)("checkin failed: " + wdr.getStatusMessage()));
            return false;
        }
        return true;
    }

    private boolean checkout(WebdavResource wdr, String path) throws IOException {
        if (!wdr.checkoutMethod(path)) {
            log.error((Object)("checkout failed: " + wdr.getStatusMessage()));
            return false;
        }
        return true;
    }

    private void disconnect(WebdavResource wdr) {
        if (wdr == null) {
            return;
        }
        try {
            wdr.close();
        }
        catch (IOException e) {
            log.error((Object)"disconnect failed", (Throwable)e);
        }
    }

    public void renameAttachment(Attachment attachment, String newName) throws IOException {
        WebdavResource wdr = null;
        try {
            wdr = this.connect();
            String oldPath = this.getAttachmentPath(attachment, wdr.getPath());
            String newPath = this.getAttachmentPath(attachment.getContent().getId(), newName, wdr.getPath());
            if (wdr.moveMethod(oldPath, newPath)) {
                attachment.setFileName(newName);
                log.info((Object)("Successfully renamed attachment from '" + oldPath + "' to '" + newPath + "'"));
            } else {
                log.error((Object)("Failed to rename attachment from '" + oldPath + "' to '" + newPath + "': " + wdr.getStatusMessage()));
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed to rename attachment: ", (Throwable)e);
            throw e;
        }
        finally {
            this.disconnect(wdr);
        }
    }

    private String getWebdavServerUri() {
        String uri = this.config.getServerUrl();
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        return uri;
    }

    private HttpURL uriToHttpURL(String uri) throws URIException {
        return (uri = URIUtil.encodePath((String)uri)).startsWith("https") ? new HttpsURL(uri.toCharArray()) : new HttpURL(uri.toCharArray());
    }

    private String getAttachmentPath(Attachment attachment, String pathPrefix) {
        return this.getAttachmentPath(attachment.getContent().getId(), attachment.getFileName(), pathPrefix);
    }

    private String getAttachmentPath(long pageId, String fileName, String pathPrefix) {
        return (pathPrefix != null ? pathPrefix : this.getWebdavServerUri()) + Long.toString(pageId) + "/" + fileName;
    }

    private String getAttachmentPathOfHistoricalVersion(Attachment attachment) {
        return this.getWebdavServerUri() + attachment.getContent().getIdAsString() + "/" + GeneralUtil.urlEncode(attachment.getFileName());
    }

    private String getAttachmentParentPath(Attachment attachment) {
        return this.getWebdavServerUri() + attachment.getContent().getIdAsString() + "/";
    }

    private String getAttachmentParentPath(ContentEntityObject content) {
        return this.getWebdavServerUri() + content.getIdAsString() + "/";
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    @Override
    public List findAllVersions(Attachment attachment) {
        ArrayList<Attachment> allVersions = new ArrayList<Attachment>();
        allVersions.add(attachment);
        try {
            WebdavResource wdr = this.connect();
            String path = this.getAttachmentPathOfHistoricalVersion(attachment);
            HttpURL httpUrl = this.uriToHttpURL(path);
            List pathsToHistoricalVersions = this.reportPathsToHistoricalVersions(wdr, httpUrl);
            if (pathsToHistoricalVersions == null) {
                return allVersions;
            }
            for (int j = 1; j < pathsToHistoricalVersions.size(); ++j) {
                Attachment historicalVersionOfAttachment = this.createAttachmentObject(attachment.getContent(), wdr, attachment.getLastModifierName());
                historicalVersionOfAttachment.setVersion(j);
                allVersions.add(historicalVersionOfAttachment);
            }
            return allVersions;
        }
        catch (Exception e) {
            log.error((Object)("Error finding versions of attachment: " + e.getMessage()), (Throwable)e);
            return allVersions;
        }
    }
}

