/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.persistence.dao.hibernate;

import com.atlassian.confluence.core.persistence.hibernate.ConfluenceHibernateObjectDao;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.persistence.dao.BlogPostDao;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.util.DateUtils;
import com.opensymphony.util.TextUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class HibernateBlogPostDao
extends ConfluenceHibernateObjectDao
implements BlogPostDao {
    public Class getPersistentClass() {
        return BlogPost.class;
    }

    public BlogPost getById(long id) {
        return (BlogPost)super.getByClassId(id);
    }

    public BlogPost getBlogPostByTitle(String spaceKey, String title) {
        if (spaceKey == null || title == null) {
            return null;
        }
        List posts = this.findNamedQueryStringParams("confluence.blogPost_findLatestBySpaceKeyTitle", "spaceKey", spaceKey.toLowerCase(), "title", GeneralUtil.specialToLowerCase(title), true);
        if (posts.size() != 1) {
            return null;
        }
        return (BlogPost)posts.get(0);
    }

    public BlogPost getBlogPost(String spaceKey, String title, Calendar day) {
        return this.getBlogPost(spaceKey, title, day, false);
    }

    public BlogPost getBlogPost(String spaceKey, String title, Calendar day, boolean eagerLoadComments) {
        if (spaceKey == null || title == null || day == null) {
            return null;
        }
        DateUtils.DateRange range = DateUtils.toDateRange((Calendar)day, (int)5);
        String theQuery = eagerLoadComments ? "confluence.blogPost_findLatestBySpaceKeyTitleAndDateRangeEagerLoadComments" : "confluence.blogPost_findLatestBySpaceKeyTitleAndDateRange";
        return (BlogPost)this.findSingleObject(this.findNamedQueryStringParams(theQuery, "spaceKey", spaceKey.toLowerCase(), "title", GeneralUtil.specialToLowerCase(title), "startDate", new Timestamp(range.startDate.getTime()), "endDate", new Timestamp(range.endDate.getTime()), true));
    }

    public List getBlogPosts(String spaceKey, Calendar date, int period) {
        if (date == null) {
            return new ArrayList();
        }
        DateUtils.DateRange range = DateUtils.toDateRange((Calendar)date, (int)period);
        return this.findNamedQueryStringParams("confluence.blogPost_findLatestBySpaceKeyAndDateRange", "spaceKey", GeneralUtil.specialToLowerCase(spaceKey), "startDate", new Timestamp(range.startDate.getTime()), "endDate", new Timestamp(range.endDate.getTime()), true);
    }

    public List getBlogPosts(final Space space, final boolean currentOnly) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = currentOnly ? session.getNamedQuery("confluence.blogPost_findCurrentBlogPostsForSpace") : session.getNamedQuery("confluence.blogPost_findBlogPostsForSpace");
                queryObject.setParameter("spaceid", (Object)new Long(space.getId()));
                queryObject.setCacheable(true);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateBlogPostDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    public List getRecentlyAddedBlogPosts(int maxCount, String spaceKey) {
        if (spaceKey == null) {
            return this.findNamedQuery("confluence.blogPost_findRecentlyAddedPosts", true, maxCount);
        }
        return this.findNamedQueryStringParam("confluence.blogPost_findRecentlyAddedPostsForSpace", "spaceKey", spaceKey.toLowerCase(), true, maxCount);
    }

    public BlogPost getFirstPostBefore(String spaceKey, Date creationDate) {
        if (spaceKey == null || creationDate == null) {
            return null;
        }
        return (BlogPost)this.findSingleObject(this.findNamedQueryStringParams("confluence.blogPost_findPostsInSpaceBefore", "spaceKey", spaceKey.toLowerCase(), "creationDate", new Timestamp(creationDate.getTime()), true, 1));
    }

    public BlogPost getFirstPostAfter(String spaceKey, Date creationDate) {
        if (spaceKey == null || creationDate == null) {
            return null;
        }
        return (BlogPost)this.findSingleObject(this.findNamedQueryStringParams("confluence.blogPost_findPostsInSpaceAfter", "spaceKey", spaceKey.toLowerCase(), "creationDate", new Timestamp(creationDate.getTime()), true, 1));
    }

    public BlogPost getFirstPostBefore(BlogPost post) {
        if (post == null) {
            return null;
        }
        return (BlogPost)this.findSingleObject(this.findNamedQueryStringParams("confluence.blogPost_findPostsInSpaceBeforeBlog", "spaceId", new Long(post.getSpace().getId()), "creationDate", new Timestamp(post.getCreationDate().getTime()), "postId", new Long(post.getId()), true, 1));
    }

    public BlogPost getFirstPostAfter(BlogPost post) {
        if (post == null) {
            return null;
        }
        return (BlogPost)this.findSingleObject(this.findNamedQueryStringParams("confluence.blogPost_findPostsInSpaceAfterBlog", "spaceId", new Long(post.getSpace().getId()), "creationDate", new Timestamp(post.getCreationDate().getTime()), "postId", new Long(post.getId()), true, 1));
    }

    public List getRecentlyAddedBlogPosts(int maxPosts, Date timeSince, String spaceKey) {
        if (maxPosts <= 0) {
            maxPosts = Integer.MAX_VALUE;
        }
        if (!TextUtils.stringSet((String)spaceKey)) {
            throw new IllegalStateException("Cross-space since-blogs query not yet supported");
        }
        return this.findNamedQueryStringParams("confluence.blogPost_findPostsInSpaceBackTo", "spaceKey", spaceKey.toLowerCase(), "creationDate", new Timestamp(timeSince.getTime()), true, maxPosts);
    }

    public BlogPost getMostRecentBlogPost(String spaceKey) {
        if (!TextUtils.stringSet((String)spaceKey)) {
            return null;
        }
        return (BlogPost)this.findSingleObject(this.findNamedQueryStringParam("confluence.blogPost_findRecentlyAddedPostsForSpace", "spaceKey", spaceKey.toLowerCase(), true, 1));
    }
}

