/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.persistence.dao.hibernate;

import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.persistence.dao.DraftDao;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.core.db.JDBCUtils;
import com.atlassian.hibernate.HibernateObjectDao;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;
import org.springframework.beans.BeanUtils;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateDraftDao
extends HibernateObjectDao
implements DraftDao {
    public static final Category log = Category.getInstance(HibernateDraftDao.class);

    public Class getPersistentClass() {
        return Draft.class;
    }

    @Override
    public void saveOrUpdate(Draft draft) throws IllegalArgumentException {
        Assert.notNull((Object)draft, (String)"Draft should not be null");
        Assert.hasText((String)draft.getPageId(), (String)("Draft content ID should be provided, " + draft));
        Assert.hasText((String)draft.getCreatorName(), (String)("Draft creator name should be provided, " + draft));
        Assert.hasText((String)draft.getDraftType(), (String)("Draft type should be provided, " + draft));
        Draft persistentDraft = this.getDraft(draft.getPageId(), draft.getCreatorName(), draft.getDraftType());
        if (persistentDraft == null) {
            this.save(draft);
        } else {
            BeanUtils.copyProperties((Object)draft, (Object)persistentDraft, (String[])new String[]{"id"});
        }
    }

    @Override
    public Draft getDraft(String pageId, String creatorName, String draftType) {
        if (StringUtils.isBlank((String)pageId) || StringUtils.isBlank((String)creatorName) || StringUtils.isBlank((String)draftType)) {
            log.warn((Object)("Could not retrieve draft with invalid draft parameters, pageId: [" + pageId + "], creatorName: [" + creatorName + "], draftType: [" + draftType + "]"));
            return null;
        }
        List results = this.findNamedQueryStringParams("confluence.draft_findByPageIdAndCreatorName", "pageId", pageId, "creatorName", creatorName, "draftType", draftType, true);
        if (results != null && results.size() > 0) {
            if (results.size() > 1) {
                log.warn((Object)("Found " + results.size() + " drafts for pageId = " + pageId + " creatorName = '" + creatorName + "' draftType = '" + draftType + "'"));
            }
            return (Draft)results.get(0);
        }
        return null;
    }

    @Override
    public Draft getDraft(long draftId) {
        return (Draft)this.getByClassId(draftId);
    }

    @Override
    public void remove(Draft draft) {
        Draft persistentDraft = this.getDraft(draft.getPageId(), draft.getCreatorName(), draft.getDraftType());
        if (persistentDraft != null) {
            super.remove((EntityObject)persistentDraft);
        }
    }

    @Override
    public void remove(long id) {
        Draft persistentDraft = (Draft)this.getByClassId(id);
        if (persistentDraft != null) {
            super.remove((EntityObject)persistentDraft);
        }
    }

    @Override
    public List<Draft> findByCreatorName(String creatorName) {
        return this.findNamedQueryStringParam("confluence.draft_findByCreatorName", "creatorName", creatorName, true);
    }

    @Override
    public void updateSpaceKey(final String newSpaceKey, final String oldSpaceKey) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.flush();
                Connection con = session.connection();
                PreparedStatement ps = null;
                try {
                    ps = con.prepareStatement("update CONTENT set DRAFTSPACEKEY = ? where DRAFTSPACEKEY = ? and CONTENTTYPE = ?");
                    ps.setString(1, newSpaceKey);
                    ps.setString(2, oldSpaceKey);
                    ps.setString(3, "draft".toUpperCase());
                    ps.execute();
                    HibernateDraftDao.this.getSessionFactory().evict(Draft.class);
                    Object var4_4 = null;
                    return var4_4;
                }
                finally {
                    JDBCUtils.close((Statement)ps);
                }
            }
        });
    }

    @Override
    public void removeAll() {
        this.getHibernateTemplate().delete("from Draft");
    }
}

