/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.templates;

import com.atlassian.confluence.event.events.template.TemplateRemoveEvent;
import com.atlassian.confluence.event.events.template.TemplateUpdateEvent;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.pages.templates.persistence.dao.PageTemplateDao;
import com.atlassian.confluence.pages.templates.variables.StringVariable;
import com.atlassian.confluence.pages.templates.variables.Variable;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.RegexUtils;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.renderer.v2.components.phrase.TemplateParamRenderComponent;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;

public class DefaultPageTemplateManager
implements PageTemplateManager {
    private EventManager eventManager;
    private PageTemplateDao pageTemplateDao;

    public void setPageTemplateDao(PageTemplateDao pageTemplateDao) {
        this.pageTemplateDao = pageTemplateDao;
    }

    public void savePageTemplate(PageTemplate pageTemplate, PageTemplate originalTemplate) {
        this.pageTemplateDao.save(pageTemplate, originalTemplate);
        this.eventManager.publishEvent((Event)new TemplateUpdateEvent(this, originalTemplate, pageTemplate));
    }

    public void refreshPageTemplate(PageTemplate pageTemplate) {
        this.pageTemplateDao.refresh(pageTemplate);
    }

    public void removePageTemplate(PageTemplate page) {
        this.removePreviousVersions(page);
        if (page.getSpace() != null) {
            page.getSpace().getPageTemplates().remove(page);
        }
        this.pageTemplateDao.remove(page);
        this.eventManager.publishEvent((Event)new TemplateRemoveEvent(this, page));
    }

    private void removePreviousVersions(PageTemplate template) {
        ArrayList<PageTemplate> templates = new ArrayList<PageTemplate>();
        List list = this.findPreviousVersions(template);
        for (PageTemplate t : list) {
            templates.add(t);
            this.pageTemplateDao.remove(t);
        }
        if (template.getSpace() != null) {
            template.getSpace().getPageTemplates().removeAll(templates);
        }
    }

    private List findPreviousVersions(PageTemplate template) {
        return this.pageTemplateDao.findPreviousVersions(template.getId());
    }

    public PageTemplate getPageTemplate(long id) {
        return this.pageTemplateDao.getById(id);
    }

    public PageTemplate getPageTemplate(String name, Space space) {
        if (space == null) {
            return this.pageTemplateDao.findPageTemplateByName(name);
        }
        return this.pageTemplateDao.findPageTemplateByNameAndSpace(name, space);
    }

    public List getPageTemplates(Space space) {
        ArrayList result = new ArrayList();
        if (space != null) {
            result.addAll(space.getPageTemplates());
        }
        result.addAll(this.getGlobalPageTemplates());
        return result;
    }

    public List getGlobalPageTemplates() {
        return this.pageTemplateDao.findAllGlobalPageTemplates();
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void removeAllPageTemplates(Space space) {
        Iterator i = space.getPageTemplates().iterator();
        while (i.hasNext()) {
            try {
                PageTemplate t = (PageTemplate)i.next();
                this.removePageTemplate(t);
            }
            catch (ConcurrentModificationException e) {
                i = space.getPageTemplates().iterator();
            }
        }
    }

    public List getTemplateVariables(PageTemplate template) {
        if (template == null) {
            return null;
        }
        ArrayList<StringVariable> variables = new ArrayList<StringVariable>();
        Matcher match = TemplateParamRenderComponent.VARIABLE_PATTERN.matcher(template.getContent());
        while (match.find()) {
            StringVariable variableObj;
            String matchText;
            String paramName = matchText = match.group(1);
            if (matchText.indexOf(124) > 0) {
                paramName = matchText.substring(0, matchText.indexOf(124));
            }
            if (variables.contains(variableObj = new StringVariable(paramName))) continue;
            variables.add(variableObj);
        }
        return variables;
    }

    public String mergeVariables(PageTemplate template, List variables) {
        String content = template.getContent();
        for (int i = 0; i < variables.size(); ++i) {
            Variable variable = (Variable)variables.get(i);
            content = content.replaceAll("@" + variable.getName() + "(\\|[\\p{L}0-9_\\(\\),]*)?@", RegexUtils.quoteReplacement(variable.getValue()));
        }
        return content;
    }
}

