/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.templates.actions;

import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.util.GeneralUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractPageTemplateAction
extends AbstractSpaceAction {
    private static final Logger log = Logger.getLogger(AbstractPageTemplateAction.class);
    protected PageTemplateManager pageTemplateManager;
    protected PageTemplate pageTemplate;
    protected long pageTemplateId;
    protected PageTemplate originalPageTemplate;
    protected String labelsString;

    public void validate() {
        super.validate();
        if (this.getLabelsString() != null && this.getLabelsString().length() > 255) {
            this.addFieldError("labelsString", this.getText("page.template.labels.toolong"));
        }
    }

    public void setPageTemplateManager(PageTemplateManager pageTemplateManager) {
        this.pageTemplateManager = pageTemplateManager;
    }

    public long getPageTemplateId() {
        return this.pageTemplateId;
    }

    public void setPageTemplateId(long pageTemplateId) {
        this.pageTemplateId = pageTemplateId;
    }

    public PageTemplate getPageTemplate() {
        if (this.pageTemplate == null && this.pageTemplateId != 0L) {
            this.pageTemplate = this.pageTemplateManager.getPageTemplate(this.pageTemplateId);
            if (this.pageTemplate != null) {
                try {
                    this.originalPageTemplate = (PageTemplate)this.pageTemplate.clone();
                }
                catch (CloneNotSupportedException e) {
                    log.error((Object)("Could not clone page template?" + e), (Throwable)e);
                }
            }
        }
        return this.pageTemplate;
    }

    public PageTemplate getPageTemplateByName(String name) {
        if (StringUtils.isNotEmpty((String)name)) {
            return this.pageTemplateManager.getPageTemplate(name, this.getSpace());
        }
        return null;
    }

    public String getLabelsString() {
        if (this.labelsString != null) {
            return this.labelsString;
        }
        if (this.pageTemplate != null) {
            this.setLabelsString(this.pageTemplate.getLabels());
        }
        return this.labelsString;
    }

    public void setLabelsString(String labelsString) {
        this.labelsString = labelsString;
    }

    public boolean isPermitted() {
        if (GeneralUtil.isSuperUser(this.getRemoteUser())) {
            return true;
        }
        Space space = this.getPageTemplate() != null ? this.getPageTemplate().getSpace() : this.getSpace();
        Object target = space != null ? space : PermissionManager.TARGET_APPLICATION;
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, target);
    }
}

