/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.thumbnail;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.core.util.thumbnail.Thumber;
import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.renderer.util.FileTypeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class DefaultThumbnailManager
implements ThumbnailManager {
    private static Logger log = Logger.getLogger(DefaultThumbnailManager.class);
    private SettingsManager settingsManager;
    private BootstrapManager bootstrapManager;
    private AttachmentManager attachmentManager;
    private Thumber thumber;

    public boolean isThumbnailable(Attachment attachment) {
        String contentType = FileTypeUtil.getContentType((String)attachment.getFileName());
        return Thumber.THUMBNAIL_MIME_TYPES.contains(contentType);
    }

    public boolean checkToolkit() {
        return this.thumber.checkToolkit();
    }

    public InputStream getThumbnailData(Attachment attachment) throws FileNotFoundException {
        File thumbnailFile = this.getThumbnailFile(attachment);
        if (!thumbnailFile.exists()) {
            throw new FileNotFoundException("Thumbnail file for attachment " + attachment.getFileName() + " is '" + thumbnailFile + "'. But this file does not exist.");
        }
        return new FileInputStream(thumbnailFile);
    }

    public Thumbnail getThumbnail(Attachment attachment) throws MalformedURLException, FileNotFoundException {
        if (!this.isThumbnailable(attachment)) {
            throw new IllegalArgumentException("Unable to create thumbnail image of attachment with id:" + attachment.getId() + " and filename: " + attachment.getFileName());
        }
        InputStream originalFileStream = this.attachmentManager.getAttachmentData(attachment);
        File thumbnailFile = this.getThumbnailFile(attachment);
        long attachmentId = attachment.getId();
        return this.getThumber().retrieveOrCreateThumbNail(originalFileStream, attachment.getFileName(), thumbnailFile, this.getMaxWidth(), this.getMaxHeight(), attachmentId);
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public Collection getThumbnails(Collection attachments) throws Exception {
        ArrayList<Thumbnail> thumbnails = new ArrayList<Thumbnail>();
        for (Attachment attachment : attachments) {
            if (!this.isThumbnailable(attachment) || !this.checkToolkit()) continue;
            thumbnails.add(this.getThumbnail(attachment));
        }
        return thumbnails;
    }

    protected File getThumbnailsFolder(Attachment attachment) {
        boolean result;
        File thumbnailsFolder = new File(this.getThumbnailPath() + attachment.getContent().getId());
        if (!thumbnailsFolder.exists() && !(result = thumbnailsFolder.mkdirs())) {
            log.error((Object)("Containing folders " + thumbnailsFolder.getAbsolutePath() + " for the attachment " + attachment.getFileName() + " could not be created"));
        }
        return thumbnailsFolder;
    }

    private String getThumbnailPath() {
        return this.bootstrapManager.getConfluenceHome() + THUMBNAIL_PATH_SUFFIX;
    }

    public File getThumbnailFile(Attachment attachment) {
        return new File(this.getThumbnailsFolder(attachment), "thumb_" + attachment.getFileName());
    }

    public boolean removeThumbnail(Attachment attachment) {
        return this.getThumbnailFile(attachment).delete();
    }

    public int getMaxHeight() {
        return this.settingsManager.getGlobalSettings().getMaxThumbHeight();
    }

    public int getMaxWidth() {
        return this.settingsManager.getGlobalSettings().getMaxThumbWidth();
    }

    public Thumber getThumber() {
        return this.thumber;
    }

    public void setThumber(Thumber thumber) {
        this.thumber = thumber;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }
}

