/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CompositeModuleDescriptorPredicate
implements ModuleDescriptorPredicate {
    private final List predicates;

    public CompositeModuleDescriptorPredicate(ModuleDescriptorPredicate predicate1, ModuleDescriptorPredicate predicate2) {
        this(new ModuleDescriptorPredicate[]{predicate1, predicate2});
    }

    public CompositeModuleDescriptorPredicate(ModuleDescriptorPredicate[] predicates) {
        this.predicates = new ArrayList<ModuleDescriptorPredicate>(Arrays.asList(predicates));
        this.sanityCheckPredicates();
    }

    public CompositeModuleDescriptorPredicate(List predicates) {
        this.predicates = new ArrayList(predicates);
        this.sanityCheckPredicates();
    }

    public boolean matches(ModuleDescriptor moduleDescriptor) {
        for (ModuleDescriptorPredicate predicate : this.predicates) {
            if (predicate.matches(moduleDescriptor)) continue;
            return false;
        }
        return true;
    }

    private void sanityCheckPredicates() {
        if (this.predicates.isEmpty()) {
            throw new IllegalArgumentException("Empty predicate list");
        }
    }
}

