/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin;

import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.confluence.event.events.admin.ConfluenceReadyEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.event.events.plugin.PluginDisableEvent;
import com.atlassian.confluence.event.events.plugin.PluginEnableEvent;
import com.atlassian.confluence.event.events.plugin.PluginEvent;
import com.atlassian.confluence.event.events.plugin.PluginInstallEvent;
import com.atlassian.confluence.event.events.plugin.PluginModuleDisableEvent;
import com.atlassian.confluence.event.events.plugin.PluginModuleEnableEvent;
import com.atlassian.confluence.event.events.plugin.PluginModuleEvent;
import com.atlassian.confluence.event.events.plugin.PluginUninstallEvent;
import com.atlassian.confluence.event.events.plugin.XWorkStateChangeEvent;
import com.atlassian.confluence.event.listeners.XWorkChangeListener;
import com.atlassian.confluence.plugin.BundledClassLoadingPluginLoader;
import com.atlassian.confluence.plugin.ConfluencePluginUtils;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.util.zip.UrlUnzipper;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import com.atlassian.event.EventManager;
import com.atlassian.plugin.DefaultPluginManager;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginManagerState;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.PluginStateStore;
import com.atlassian.plugin.classloader.DelegationClassLoader;
import com.atlassian.plugin.loaders.SinglePluginLoader;
import com.atlassian.plugin.store.MemoryPluginStateStore;
import com.atlassian.plugin.util.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.zip.ZipEntry;
import org.apache.log4j.Category;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class ConfluencePluginManager
extends DefaultPluginManager
implements ApplicationListener {
    private static final Category log = Category.getInstance(ConfluencePluginManager.class);
    private static final String ATLASSIAN_BUNDLED_PLUGINS_ZIP = "atlassian-bundled-plugins.zip";
    private BootstrapManager bootstrapManager;
    private boolean initialised = false;
    private DelegationClassLoader applicationClassLoader;
    private EventManager eventManager;
    private static final String XWORK_LISTENER_NAME = "xworklistener";
    private PluginStateStore localStateStore = new MemoryPluginStateStore();

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public ConfluencePluginManager(PluginStateStore pluginStateStore, List pluginLoaders, ModuleDescriptorFactory moduleDescriptorFactory, BootstrapManager bootstrapManager, boolean extractBundledPlugins) {
        super(pluginStateStore, ConfluencePluginManager.filterPluginLoaders(pluginLoaders), moduleDescriptorFactory);
        this.bootstrapManager = bootstrapManager;
        if (extractBundledPlugins) {
            this.extractBundledPlugins();
        }
    }

    protected PluginStateStore getLocalPluginStateStore() {
        return this.localStateStore;
    }

    protected PluginManagerState getState() {
        return this.getLocalPluginStateStore().loadPluginState();
    }

    protected void notifyPluginEnabled(Plugin plugin) {
        this.enablePluginState(plugin, this.getLocalPluginStateStore());
        super.notifyPluginEnabled(plugin);
    }

    protected void notifyModuleDisabled(ModuleDescriptor module) {
        super.notifyModuleDisabled(module);
        this.disablePluginModuleState(module, this.getLocalPluginStateStore());
    }

    protected void notifyPluginDisabled(Plugin plugin) {
        super.notifyPluginDisabled(plugin);
        this.disablePluginState(plugin, this.getLocalPluginStateStore());
    }

    protected void notifyModuleEnabled(ModuleDescriptor module) {
        super.notifyModuleEnabled(module);
        this.enablePluginModuleState(module, this.getLocalPluginStateStore());
    }

    protected void notifyUninstallPlugin(Plugin plugin) {
        super.notifyUninstallPlugin(plugin);
        this.removeStateFromStore(this.getLocalPluginStateStore(), plugin);
    }

    private static List filterPluginLoaders(List list) {
        ListIterator<SinglePluginLoader> it = list.listIterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof String) {
                it.remove();
                it.add(new SinglePluginLoader((String)o));
                continue;
            }
            if (!ConfluenceSystemProperties.isBundledPluginsDisabled() || !(o instanceof BundledClassLoadingPluginLoader)) continue;
            log.info((Object)"Bundled plugins have been disabled. Removing bundled plugin loader.");
            it.remove();
        }
        return list;
    }

    public void init() throws PluginParseException {
        if (this.initialised) {
            log.warn((Object)"Init() called on an already initialised plugin manager. Ignoring.");
            return;
        }
        if (this.applicationClassLoader != null) {
            this.applicationClassLoader.setDelegateClassLoader(this.getClassLoader());
        }
        this.getLocalPluginStateStore().savePluginState(this.getStore().loadPluginState());
        super.init();
        this.initialised = true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ConfluenceReadyEvent) {
            this.processConfluenceReadyEvent();
            this.eventManager.registerListener(XWORK_LISTENER_NAME, (EventListener)new XWorkChangeListener());
            this.eventManager.publishEvent((Event)new XWorkStateChangeEvent((Object)this));
            return;
        }
        if (!(event instanceof ClusterEventWrapper)) {
            return;
        }
        Event wrappedEvent = ((ClusterEventWrapper)event).getEvent();
        if (!(wrappedEvent instanceof PluginEvent)) {
            return;
        }
        PluginEvent pluginEvent = (PluginEvent)wrappedEvent;
        log.debug((Object)("Received cluster plugin event: " + pluginEvent));
        if (pluginEvent instanceof PluginModuleEvent) {
            this.processModuleEvent(pluginEvent);
        } else {
            this.processPluginEvent(pluginEvent);
        }
    }

    private void processModuleEvent(PluginEvent pluginEvent) {
        ModuleDescriptor module = this.getPluginModule(pluginEvent.getPluginKey());
        if (module == null) {
            log.error((Object)("Could not process the event [" + pluginEvent + "] for plugin key '" + pluginEvent.getPluginKey() + "' because the component could not be found."));
            return;
        }
        if (pluginEvent instanceof PluginModuleEnableEvent) {
            this.notifyModuleEnabled(module);
            return;
        }
        if (pluginEvent instanceof PluginModuleDisableEvent) {
            this.notifyModuleDisabled(module);
        }
    }

    private void processPluginEvent(PluginEvent pluginEvent) {
        if (pluginEvent instanceof PluginInstallEvent) {
            this.processClusteredInstallEvent(pluginEvent);
            return;
        }
        Plugin plugin = this.getPlugin(pluginEvent.getPluginKey());
        if (plugin == null) {
            log.error((Object)("Could not process the event [" + pluginEvent + "] for plugin key '" + pluginEvent.getPluginKey() + "' because the component could not be found."));
            return;
        }
        if (pluginEvent instanceof PluginUninstallEvent) {
            this.processClusteredUninstallEvent(plugin);
            return;
        }
        if (pluginEvent instanceof PluginEnableEvent) {
            this.notifyPluginEnabled(plugin);
            return;
        }
        if (pluginEvent instanceof PluginDisableEvent) {
            this.notifyPluginDisabled(plugin);
        }
    }

    private void processConfluenceReadyEvent() {
        try {
            this.init();
        }
        catch (PluginParseException e) {
            throw new RuntimeException("Error initialising plugin manager: " + e.getMessage(), e);
        }
    }

    private void processClusteredUninstallEvent(Plugin plugin) {
        try {
            this.unloadPlugin(plugin);
        }
        catch (PluginException e) {
            log.error((Object)("Error uninstalling plugin: " + plugin.getKey()), (Throwable)e);
        }
    }

    private void processClusteredInstallEvent(PluginEvent pluginEvent) {
        try {
            this.scanForNewPlugins();
        }
        catch (PluginParseException ppe) {
            log.error((Object)("Error installing plugin from another node:" + pluginEvent), (Throwable)ppe);
        }
    }

    private void extractBundledPlugins() {
        URL zipUrl = ClassLoaderUtils.getResource((String)"com/atlassian/confluence/setup/atlassian-bundled-plugins.zip", ConfluencePluginManager.class);
        if (zipUrl == null) {
            log.error((Object)"Couldn't find atlassian-bundled-plugins.zip on classpath");
            return;
        }
        try {
            File destDir = ConfluencePluginUtils.getBundledPluginDirectory(this.bootstrapManager);
            UrlUnzipper unzipper = new UrlUnzipper(zipUrl, destDir);
            ArrayList<String> zipContents = new ArrayList<String>();
            ZipEntry[] zipEntries = unzipper.entries();
            for (int i = 0; i < zipEntries.length; ++i) {
                zipContents.add(zipEntries[i].getName());
            }
            List bundledPluginContents = this.getContentsOfBundledPluginsDir();
            if (!((Object)bundledPluginContents).equals(zipContents)) {
                FileUtils.deleteDir((File)destDir);
                unzipper.unzip();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Bundled Plugins directory contents match Bundled Plugins zip contents. Do nothing.");
            }
        }
        catch (IOException e) {
            log.error((Object)"Found atlassian-bundled-plugins.zip, but failed to read file", (Throwable)e);
        }
    }

    protected List getContentsOfBundledPluginsDir() {
        FilenameFilter filter;
        File dir = ConfluencePluginUtils.getBundledPluginDirectory(this.bootstrapManager);
        String[] children = dir.list(filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (children == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> bundledPluginContents = new ArrayList<String>();
        if (log.isDebugEnabled() && children.length > 0) {
            log.debug((Object)("Listing JAR files in " + dir.getAbsolutePath()));
        }
        for (int i = 0; i < children.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)children[i]);
            }
            bundledPluginContents.add(children[i]);
        }
        return bundledPluginContents;
    }

    public void setApplicationClassLoader(DelegationClassLoader applicationClassLoader) {
        this.applicationClassLoader = applicationClassLoader;
    }
}

