/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin;

import com.atlassian.confluence.plugin.ConfluencePluginUtils;
import com.atlassian.confluence.plugin.persistence.PluginData;
import com.atlassian.confluence.plugin.persistence.PluginDataDao;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.core.util.FileUtils;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.loaders.ClassLoadingPluginLoader;
import com.atlassian.plugin.loaders.PluginFactory;
import com.atlassian.plugin.loaders.PluginLoader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class DatabaseClassLoadingPluginLoader
implements PluginLoader {
    private static final Logger log = Logger.getLogger(DatabaseClassLoadingPluginLoader.class);
    private ClassLoadingPluginLoader delegateLoader;
    private PluginDataDao pluginDataDao;
    private final PluginFactory pluginFactory;
    private File workDir;
    private Date lastScanDate;
    public static final int RESCAN_FUDGE_FACTOR_MS = 60000;

    public DatabaseClassLoadingPluginLoader(BootstrapManager bootstrapManager, PluginFactory pluginFactory) {
        this.pluginFactory = pluginFactory;
        this.workDir = new File(new File(bootstrapManager.getConfluenceHome()), "plugin-cache");
        this.delegateLoader = new ClassLoadingPluginLoader(this.workDir, pluginFactory, ConfluencePluginUtils.getPluginTempDirectory(bootstrapManager));
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public void setPluginDataDao(PluginDataDao pluginDataDao) {
        this.pluginDataDao = pluginDataDao;
    }

    public synchronized Collection loadAllPlugins(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        this.lastScanDate = new Date();
        this.clearWorkDir();
        Iterator pluginIterator = this.pluginDataDao.getAllPluginData();
        while (pluginIterator.hasNext()) {
            PluginData pluginData = (PluginData)pluginIterator.next();
            this.writePluginData(pluginData);
        }
        return this.delegateLoader.loadAllPlugins(moduleDescriptorFactory);
    }

    private void writePluginData(PluginData pluginData) {
        File pluginFile = new File(this.workDir, pluginData.getFileName());
        try {
            BufferedOutputStream fileOutputStream = new BufferedOutputStream(new FileOutputStream(pluginFile));
            IOUtils.copy(pluginData.getData(), fileOutputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write plugin data to the filesystem: " + pluginFile, e);
        }
    }

    private void clearWorkDir() {
        if (this.workDir.exists() && !FileUtils.deleteDir((File)this.workDir)) {
            log.error((Object)("Couldn't remove plugin working directory: " + this.workDir.getAbsolutePath()), (Throwable)new RuntimeException("Unable to delete working directory"));
            this.workDir = new File(this.workDir.getParent(), "plugin-cache-" + System.currentTimeMillis());
            this.delegateLoader = new ClassLoadingPluginLoader(this.workDir, this.pluginFactory);
            log.error((Object)("New plugin working directory workDir : " + this.workDir.getAbsolutePath()));
        }
        this.workDir.mkdirs();
    }

    public boolean supportsRemoval() {
        return true;
    }

    public boolean supportsAddition() {
        return true;
    }

    public synchronized Collection addFoundPlugins(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Date scanStart = new Date();
        Iterator pluginDataIterator = this.pluginDataDao.getAllPluginData();
        while (pluginDataIterator.hasNext()) {
            PluginData pluginData = (PluginData)pluginDataIterator.next();
            if (pluginData.getLastModificationDate().getTime() <= this.lastScanDate.getTime() - 60000L) continue;
            this.writePluginData(pluginData);
        }
        this.lastScanDate = scanStart;
        return this.delegateLoader.addFoundPlugins(moduleDescriptorFactory);
    }

    public void removePlugin(Plugin plugin) throws PluginException {
        this.delegateLoader.removePlugin(plugin);
    }
}

