/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin;

import com.atlassian.confluence.event.events.plugin.PluginDisableEvent;
import com.atlassian.confluence.event.events.plugin.PluginEnableEvent;
import com.atlassian.confluence.event.events.plugin.PluginInstallEvent;
import com.atlassian.confluence.event.events.plugin.PluginModuleDisableEvent;
import com.atlassian.confluence.event.events.plugin.PluginModuleEnableEvent;
import com.atlassian.confluence.event.events.plugin.PluginUninstallEvent;
import com.atlassian.confluence.plugin.persistence.PluginDataDao;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginJar;
import com.atlassian.plugin.PluginParseException;

public class EventDispatchingPluginController
implements PluginController {
    private EventManager eventManager;
    private PluginController pluginController;
    private PluginDataDao pluginDataDao;

    public void setPluginDataDao(PluginDataDao pluginDataDao) {
        this.pluginDataDao = pluginDataDao;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setPluginController(PluginController pluginController) {
        this.pluginController = pluginController;
    }

    public void enablePlugin(String key) {
        this.pluginController.enablePlugin(key);
        this.eventManager.publishEvent((Event)new PluginEnableEvent(this, key));
    }

    public void disablePlugin(String key) {
        this.pluginController.disablePlugin(key);
        this.eventManager.publishEvent((Event)new PluginDisableEvent(this, key));
    }

    public void enablePluginModule(String completeKey) {
        this.pluginController.enablePluginModule(completeKey);
        this.eventManager.publishEvent((Event)new PluginModuleEnableEvent(this, completeKey));
    }

    public void disablePluginModule(String completeKey) {
        this.pluginController.disablePluginModule(completeKey);
        this.eventManager.publishEvent((Event)new PluginModuleDisableEvent(this, completeKey));
    }

    public String installPlugin(PluginJar pluginJar) throws PluginParseException {
        String key = this.pluginController.installPlugin(pluginJar);
        this.eventManager.publishEvent((Event)new PluginInstallEvent(this, key));
        return key;
    }

    public void uninstall(Plugin plugin) throws PluginException {
        this.pluginDataDao.remove(plugin.getKey());
        this.pluginController.uninstall(plugin);
        this.eventManager.publishEvent((Event)new PluginUninstallEvent(this, plugin.getKey()));
    }

    public int scanForNewPlugins() throws PluginParseException {
        return this.pluginController.scanForNewPlugins();
    }
}

