/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.confluence.setup.ConfluenceListableBeanFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.spring.container.ContainerContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.spring.container.SpringContainerContext;
import com.opensymphony.util.TextUtils;
import javax.servlet.ServletContext;
import org.apache.log4j.Category;
import org.dom4j.Element;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ComponentModuleDescriptor
extends AbstractModuleDescriptor
implements StateAware,
ApplicationContextAware {
    private static final Category log = Category.getInstance(ComponentModuleDescriptor.class);
    String alias;
    private ApplicationContext appContext;

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.alias = element.attributeValue("alias");
        if (!TextUtils.stringSet((String)this.alias)) {
            this.alias = this.getKey();
        }
    }

    public Object getModule() {
        throw new UnsupportedOperationException("You cannot retrieve a component instance - Spring-ified");
    }

    public void enabled() {
        ConfluenceListableBeanFactory beanFactory = this.getGlobalBeanFactoryUsingHacks();
        if (beanFactory != null) {
            boolean definitionExists;
            try {
                definitionExists = beanFactory.getBeanDefinition(this.alias) != null;
            }
            catch (NoSuchBeanDefinitionException e) {
                definitionExists = false;
            }
            if (definitionExists) {
                throw new IllegalStateException("Can not overwrite an existing bean definition: " + this.alias);
            }
            log.debug((Object)("Creating bean definition for " + this.alias + " with class " + this.getModuleClass().getName()));
            RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(this.getModuleClass(), 1, false);
            log.debug((Object)("Registering bean definition for " + this.alias + " with class " + this.getModuleClass().getName()));
            beanFactory.registerBeanDefinition(this.alias, (BeanDefinition)rootBeanDefinition);
            Object o = beanFactory.getBean(this.alias);
            if (o instanceof StateAware) {
                StateAware sa = (StateAware)o;
                sa.enabled();
            }
        }
    }

    public void disabled() {
        ConfluenceListableBeanFactory beanFactory;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Disabling component module " + this.getKey()));
        }
        if ((beanFactory = this.getGlobalBeanFactoryUsingHacks()) != null) {
            Object o = null;
            try {
                o = beanFactory.getBean(this.alias);
            }
            catch (NoSuchBeanDefinitionException nsbe) {
                // empty catch block
            }
            if (o != null && o instanceof StateAware) {
                StateAware sa = (StateAware)o;
                sa.disabled();
            }
            log.debug((Object)("Removing bean definition for " + this.alias));
            beanFactory.unregisterBeanDefinition(this.alias);
        }
    }

    private ConfluenceListableBeanFactory getGlobalBeanFactoryUsingHacks() {
        ApplicationContext applicationContext = this.getApplicationContextWithHack();
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)applicationContext;
            if (configurableApplicationContext.getBeanFactory() instanceof ConfluenceListableBeanFactory) {
                return (ConfluenceListableBeanFactory)configurableApplicationContext.getBeanFactory();
            }
            log.error((Object)"Failed to lookup global bean factory - BeanFactory was not a ConfluenceListableBeanFactory?");
        } else {
            log.error((Object)"Failed to lookup global bean factory - ApplicationContext was not a ConfigurableApplicationContext?");
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.appContext = applicationContext;
    }

    private ApplicationContext getApplicationContextWithHack() {
        SpringContainerContext springContainerContext;
        ServletContext servletContext;
        if (this.appContext != null) {
            return this.appContext;
        }
        log.warn((Object)"Using hacks to get application context");
        ContainerContext containerContext = ContainerManager.getInstance().getContainerContext();
        if (containerContext instanceof SpringContainerContext && (servletContext = (springContainerContext = (SpringContainerContext)containerContext).getServletContext()) != null) {
            return WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        }
        return null;
    }
}

