/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.i18n.UserLocaleAware;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;

public abstract class ConfluenceVelocityModuleDescriptor
extends AbstractModuleDescriptor
implements UserLocaleAware {
    private static final Category log = Category.getInstance(ConfluenceVelocityModuleDescriptor.class);
    private static final String RESOURCE_TYPE_VELOCITY = "velocity";
    public static final String RESOURCE_TYPE_I18N = "i18n";
    protected I18NBeanFactory i18NBeanFactory;
    protected LocaleManager localeManager;

    @HtmlSafe
    public String getHtml(String resourceName) {
        return this.getHtml(resourceName, new HashMap());
    }

    @HtmlSafe
    public String getHtml(String resourceName, Map startingParams) {
        ResourceDescriptor resource = this.getResourceDescriptor(RESOURCE_TYPE_VELOCITY, resourceName);
        if (resource == null) {
            return null;
        }
        try {
            Map velocityContext = MacroUtils.defaultVelocityContext();
            velocityContext.put(RESOURCE_TYPE_I18N, this.i18NBeanFactory.getI18NBean());
            if (TextUtils.stringSet((String)resource.getLocation())) {
                return VelocityUtils.getRenderedTemplate(resource.getLocation(), velocityContext);
            }
            return VelocityUtils.getRenderedContent(resource.getContent(), velocityContext);
        }
        catch (Exception e) {
            log.error((Object)("Error while rendering velocity template for '" + resourceName + "'."), (Throwable)e);
            return "";
        }
    }

    public void setI18NBeanFactory(I18NBeanFactory i18NBeanFactory) {
        this.i18NBeanFactory = i18NBeanFactory;
    }

    public void setLocaleManager(LocaleManager localeManager) {
        this.localeManager = localeManager;
    }
}

