/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.opensymphony.util.TextUtils;
import org.dom4j.Element;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;

public class JobModuleDescriptor
extends AbstractModuleDescriptor
implements StateAware {
    private JobDetail jobDetail;
    private boolean perClusterJob = false;

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        if (element.attribute("perClusterJob") != null) {
            this.perClusterJob = "true".equalsIgnoreCase(element.attributeValue("perClusterJob"));
        }
    }

    public Object getModule() {
        if (this.jobDetail == null) {
            this.jobDetail = new JobDetail();
            this.jobDetail.setGroup(this.getPluginKey());
            this.jobDetail.setName(this.getKey());
            this.jobDetail.setJobClass(this.getModuleClass());
            if (TextUtils.stringSet((String)this.getDescription())) {
                this.jobDetail.setDescription(this.getDescription());
            }
            JobDataMap jobDetailMap = new JobDataMap();
            jobDetailMap.put("runOncePerCluster", String.valueOf(this.perClusterJob));
            this.jobDetail.setJobDataMap(jobDetailMap);
        }
        return this.jobDetail;
    }

    public void enabled() {
        Object o = this.getModule();
        if (o instanceof StateAware) {
            StateAware stateAware = (StateAware)o;
            stateAware.enabled();
        }
    }

    public void disabled() {
        Object o = this.getModule();
        if (o instanceof StateAware) {
            StateAware stateAware = (StateAware)o;
            stateAware.disabled();
        }
    }
}

