/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.confluence.plugin.ConfluencePluginUtils;
import com.atlassian.confluence.servlet.simpledisplay.PathConverter;
import com.atlassian.confluence.servlet.simpledisplay.PathConverterManager;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.util.TextUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class PathConverterModuleDescriptor
extends AbstractModuleDescriptor
implements StateAware {
    private PathConverter pathConverter;
    private PathConverterManager pathConverterManager;
    private static final int DEFAULT_WEIGHT = 100;
    private int weight;

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.weight = this.calculateWeight(element);
        this.pathConverterManager = (PathConverterManager)ContainerManager.getComponent((String)"pathConverterManager");
    }

    public Object getModule() {
        if (this.pathConverter == null) {
            this.pathConverter = (PathConverter)ConfluencePluginUtils.instantiatePluginModule(this.plugin, this.getModuleClass());
        }
        return this.pathConverter;
    }

    public void enabled() {
        PathConverter pathConverter = (PathConverter)this.getModule();
        if (pathConverter != null) {
            this.pathConverterManager.addPathConverter(this.weight, pathConverter);
        }
    }

    public void disabled() {
        PathConverter pathConverter = (PathConverter)this.getModule();
        if (pathConverter != null) {
            this.pathConverterManager.removePathConverter(pathConverter);
        }
    }

    private int calculateWeight(Element element) {
        String value;
        Attribute att = element.attribute("weight");
        if (att != null && TextUtils.stringSet((String)(value = att.getValue()))) {
            return TextUtils.parseInt((String)value);
        }
        return 100;
    }
}

