/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor;

import com.atlassian.confluence.plugin.ConfluencePluginUtils;
import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.confluence.themes.PluginThemeStylesheet;
import com.atlassian.confluence.themes.Theme;
import com.atlassian.confluence.themes.ThemedDecorator;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.Resourced;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class ThemeModuleDescriptor
extends AbstractModuleDescriptor {
    private static final Logger log = Logger.getLogger(ThemeModuleDescriptor.class);
    private PluginAccessor pluginAccessor;
    private Theme theme;
    private String colourSchemeKey;
    private List layoutKeys = new ArrayList();

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        Iterator it = element.elementIterator();
        while (it.hasNext()) {
            Element child = (Element)it.next();
            if (child.getName().equals("colour-scheme") || child.getName().equals("color-scheme")) {
                if (TextUtils.stringSet((String)this.colourSchemeKey)) {
                    log.warn((Object)(this.getCompleteKey() + " should not define multiple colour schemes. All but one ignored."));
                }
                this.colourSchemeKey = child.attributeValue("key");
            }
            if (!child.getName().equals("layout")) continue;
            this.layoutKeys.add(child.attributeValue("key"));
        }
    }

    public Object getModule() {
        if (this.theme == null) {
            this.theme = (Theme)ConfluencePluginUtils.instantiatePluginModule(this.plugin, this.getModuleClass());
            this.theme.init(this);
        }
        return this.theme;
    }

    public ColourScheme getColourScheme() {
        if (this.colourSchemeKey == null) {
            return null;
        }
        ModuleDescriptor colourSchemeDesc = this.pluginAccessor.getPluginModule(this.colourSchemeKey);
        if (colourSchemeDesc == null) {
            log.error((Object)(this.getCompleteKey() + "  unable to locate colour scheme " + this.colourSchemeKey));
            return null;
        }
        Object colourScheme = colourSchemeDesc.getModule();
        if (!(colourScheme instanceof ColourScheme)) {
            log.error((Object)(this.getCompleteKey() + " unable to load colour scheme " + this.colourSchemeKey + " wrong type: " + colourScheme.getClass().getName()));
            return null;
        }
        return (ColourScheme)colourScheme;
    }

    public List getLayouts() {
        ArrayList layouts = new ArrayList(this.layoutKeys.size());
        for (String key : this.layoutKeys) {
            this.addLayout(layouts, key);
        }
        return layouts;
    }

    private void addLayout(List layouts, String key) {
        ModuleDescriptor desc = this.pluginAccessor.getPluginModule(key);
        if (desc == null) {
            log.error((Object)(this.getCompleteKey() + " unable to locate layout " + key));
            return;
        }
        Object layout = desc.getModule();
        if (!(layout instanceof ThemedDecorator)) {
            log.error((Object)(this.getCompleteKey() + " unable to load layout " + key + " wrong type: " + layout.getClass().getName()));
            return;
        }
        layouts.add(layout);
    }

    public Collection getStylesheets() {
        LinkedList<PluginThemeStylesheet> result = new LinkedList<PluginThemeStylesheet>();
        for (ResourceDescriptor resource : this.getStylesheetResourceDescriptors((Resourced)this)) {
            PluginThemeStylesheet stylesheet = new PluginThemeStylesheet(this.getCompleteKey(), resource);
            result.add(stylesheet);
        }
        return result;
    }

    private Collection getStylesheetResourceDescriptors(Resourced resourced) {
        if (resourced == null) {
            return Collections.EMPTY_LIST;
        }
        List resources = resourced.getResourceDescriptors();
        if (resources == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList(resources);
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            ResourceDescriptor descriptor = (ResourceDescriptor)iter.next();
            if (descriptor.getType().equals("stylesheet") || descriptor.getName().endsWith(".css")) continue;
            iter.remove();
        }
        return result;
    }
}

