/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor.rpc;

import com.atlassian.confluence.plugin.ConfluencePluginUtils;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public abstract class RpcModuleDescriptor
extends AbstractModuleDescriptor
implements StateAware {
    public static final Logger log = Logger.getLogger(RpcModuleDescriptor.class);
    protected String servicePath;
    protected String publishedInterface;
    protected boolean authenticated;
    private Object rpcHandler;

    protected abstract void resetServerConfig();

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.servicePath = element.element("service-path").getTextTrim();
        Element auth = element.element("authenticate");
        if (auth != null) {
            this.authenticated = "true".equalsIgnoreCase(auth.getTextTrim());
        }
    }

    public Object getModule() {
        if (this.rpcHandler == null) {
            this.rpcHandler = ConfluencePluginUtils.instantiatePluginModule(this.plugin, this.getModuleClass());
        }
        return this.rpcHandler;
    }

    public void enabled() {
        this.resetServerConfig();
    }

    public void disabled() {
        this.resetServerConfig();
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public String getServicePath() {
        return this.servicePath;
    }

    public Class getPublishedInterface() throws ClassNotFoundException {
        return this.plugin.loadClass(this.publishedInterface, this.getModuleClass());
    }
}

