/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor.rpc;

import com.atlassian.confluence.plugin.descriptor.rpc.RpcModuleDescriptor;
import com.atlassian.confluence.rpc.RpcServer;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import org.dom4j.Element;

public class SoapModuleDescriptor
extends RpcModuleDescriptor {
    private RpcServer glueSoapServer;
    private RpcServer axisSoapServer;
    private String serviceName;

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.publishedInterface = element.element("published-interface").getTextTrim();
        this.serviceName = element.element("service-name").getTextTrim();
    }

    protected void resetServerConfig() {
        this.reloadSoapServer("Glue", this.glueSoapServer);
        this.reloadSoapServer("Axis", this.axisSoapServer);
    }

    private void reloadSoapServer(String serverName, RpcServer soapServer) {
        if (soapServer == null) {
            log.fatal((Object)("Unable to reload " + serverName + " SOAP server configuration: " + serverName + " SOAP server component available"));
        } else {
            soapServer.reloadConfiguration();
        }
    }

    public void setGlueSoapServer(RpcServer glueSoapServer) {
        this.glueSoapServer = glueSoapServer;
    }

    public void setAxisSoapServer(RpcServer axisSoapServer) {
        this.axisSoapServer = axisSoapServer;
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

