/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.descriptor.web.conditions;

import com.atlassian.confluence.core.PageContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.user.User;
import java.util.Map;

public class CreateContentCondition
extends BaseConfluenceCondition {
    private PermissionManager permissionManager;
    private Class contentTypeClass = null;

    public void init(Map params) throws PluginParseException {
        String contentType = (String)params.get("content");
        if ("Page".equalsIgnoreCase(contentType)) {
            this.contentTypeClass = Page.class;
        } else if ("News".equalsIgnoreCase(contentType)) {
            this.contentTypeClass = BlogPost.class;
        } else if ("Comment".equalsIgnoreCase(contentType)) {
            this.contentTypeClass = Comment.class;
        } else if ("Attachment".equalsIgnoreCase(contentType)) {
            this.contentTypeClass = Attachment.class;
        } else if ("Space".equalsIgnoreCase(contentType)) {
            this.contentTypeClass = Space.class;
        } else {
            throw new PluginParseException("Could not determine type of class to check permissions against: contentType = " + contentType);
        }
        super.init(params);
    }

    public boolean shouldDisplay(WebInterfaceContext context) {
        User user = context.getUser();
        if (Space.class.equals((Object)this.contentTypeClass)) {
            return this.permissionManager.hasCreatePermission(user, PermissionManager.TARGET_APPLICATION, this.contentTypeClass);
        }
        if (SpaceContentEntityObject.class.isAssignableFrom(this.contentTypeClass)) {
            return this.permissionManager.hasCreatePermission(user, context.getSpace(), this.contentTypeClass);
        }
        if (PageContentEntityObject.class.isAssignableFrom(this.contentTypeClass) || Attachment.class.equals((Object)this.contentTypeClass)) {
            return this.permissionManager.hasCreatePermission(user, context.getPage(), this.contentTypeClass);
        }
        return false;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }
}

