/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.webresource;

import com.atlassian.confluence.importexport.resource.ResourceAccessor;
import com.atlassian.confluence.plugin.webresource.ConfluenceWebResourceManager;
import com.atlassian.confluence.plugin.webresource.CssResourceCounterManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceManagerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class DefaultConfluenceWebResourceManager
extends WebResourceManagerImpl
implements ConfluenceWebResourceManager {
    private static final Logger log = Logger.getLogger(DefaultConfluenceWebResourceManager.class);
    private CssResourceCounterManager cssResourceCounterManager;
    private PluginAccessor pluginAccessor;
    private ResourceAccessor resourceAccessor;
    private SettingsManager settingsManager;

    public DefaultConfluenceWebResourceManager(WebResourceIntegration webResourceIntegration) {
        super(webResourceIntegration);
    }

    @HtmlSafe
    public String getResources() {
        StringWriter writer = new StringWriter();
        this.includeResources(writer);
        return writer.toString();
    }

    public void requireResource(String resourceName) {
        log.info((Object)("Requiring delayed resource: " + resourceName));
        super.requireResource(resourceName);
    }

    public String getGlobalCssResourcePrefix() {
        int globalCssResourceCounter = this.cssResourceCounterManager.getGlobalCssResourceCounter();
        return this.getStaticResourcePrefix(String.valueOf(globalCssResourceCounter));
    }

    public String getSpaceCssPrefix(String spaceKey) {
        int spaceCssResourceCounter = this.cssResourceCounterManager.getSpaceCssResourceCounter(spaceKey);
        return this.getStaticResourcePrefix(String.valueOf(spaceCssResourceCounter));
    }

    public String getResourceContent(String resourceName) {
        ModuleDescriptor descriptor = this.pluginAccessor.getEnabledPluginModule(resourceName);
        if (descriptor == null) {
            return "/* Error loading resource \"" + resourceName + "\".  Resource not found */\n";
        }
        StringBuilder sb = new StringBuilder();
        for (ResourceDescriptor resourceDescriptor : descriptor.getResourceDescriptors()) {
            InputStream is = this.getResourceStream(descriptor.getPlugin(), resourceDescriptor);
            if (is == null) {
                sb.append("/* Could not locate resource: ").append(resourceDescriptor.getLocation()).append(" */\n");
                continue;
            }
            try {
                String content = IOUtils.toString((InputStream)is, (String)this.settingsManager.getGlobalSettings().getDefaultEncoding());
                sb.append(content).append("\n");
            }
            catch (IOException e) {
                log.error((Object)e);
                sb.append("/* Error reading resource at \"").append(resourceDescriptor.getLocation()).append("\" */\n");
            }
        }
        return sb.toString();
    }

    private InputStream getResourceStream(Plugin plugin, ResourceDescriptor resourceDescriptor) {
        if ("webContext".equalsIgnoreCase(resourceDescriptor.getParameter("source"))) {
            return this.resourceAccessor.getResource(resourceDescriptor.getLocation());
        }
        return plugin.getClassLoader().getResourceAsStream(resourceDescriptor.getLocation());
    }

    public void invalidateGlobalCss() {
        this.cssResourceCounterManager.invalidateGlobalCssResourceCounter();
    }

    public void invalidateSpaceCss(String spaceKey) {
        this.cssResourceCounterManager.invalidateSpaceCssResourceCounter(spaceKey);
    }

    public void setCssResourceCounterManager(CssResourceCounterManager cssResourceCounterManager) {
        this.cssResourceCounterManager = cssResourceCounterManager;
    }

    public void setResourceAccessor(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }
}

