/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.webresource;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.plugin.webresource.CssResourceCounterManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;

public class DefaultCssResourceCounterManager
implements CssResourceCounterManager {
    private BandanaManager bandanaManager;

    public void invalidateGlobalCssResourceCounter() {
        int old = this.getGlobalCssResourceCounter();
        this.setGlobalCssResourceCounter(new Integer(old + 1));
    }

    public void invalidateSpaceCssResourceCounter(String spaceKey) {
        int old = this.getSpaceCssResourceCounter(spaceKey);
        this.setSpaceCssResourceCounter(spaceKey, new Integer(old + 1));
    }

    public int getGlobalCssResourceCounter() {
        Integer globalCssResourceCounter = (Integer)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "atlassian.confluence.css.resource.counter", false);
        if (globalCssResourceCounter == null) {
            globalCssResourceCounter = new Integer(1);
            this.setGlobalCssResourceCounter(globalCssResourceCounter);
        }
        return globalCssResourceCounter;
    }

    public int getSpaceCssResourceCounter(String spaceKey) {
        Integer spaceCssResourceCounter = (Integer)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), "atlassian.confluence.css.resource.counter", false);
        if (spaceCssResourceCounter == null) {
            spaceCssResourceCounter = new Integer(1);
            this.setSpaceCssResourceCounter(spaceKey, spaceCssResourceCounter);
        }
        return spaceCssResourceCounter;
    }

    private void setGlobalCssResourceCounter(Integer globalCssResourceCounter) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "atlassian.confluence.css.resource.counter", (Object)globalCssResourceCounter);
    }

    private void setSpaceCssResourceCounter(String spaceKey, Integer spaceCssResourceCounter) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), "atlassian.confluence.css.resource.counter", (Object)spaceCssResourceCounter);
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }
}

