/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.renderer;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.PageContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.LinkContext;
import java.util.Calendar;

public class PageContext
extends RenderContext
implements LinkContext {
    private String spaceKey;
    private Calendar postingDay;
    private ContentEntityObject entity;
    private ContentEntityObject latestVersionOfEntity;
    private PageContext originalContext;

    public PageContext() {
        this((String)null);
    }

    public PageContext(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public PageContext(ContentEntityObject entity) {
        this(entity, null);
    }

    public PageContext(ContentEntityObject entity, PageContext previousContext) {
        super(previousContext == null ? null : previousContext.getRenderedContentStore());
        this.entity = entity;
        if (previousContext != null) {
            this.originalContext = previousContext.getOriginalContext();
            this.setAttachmentsPath(previousContext.getAttachmentsPath());
            this.setImagePath(previousContext.getImagePath());
            this.setSiteRoot(previousContext.getSiteRoot());
            this.setBaseUrl(previousContext.getBaseUrl());
            this.setLinkRenderer(previousContext.getLinkRenderer());
            this.setEmbeddedResourceRenderer(previousContext.getEmbeddedResourceRenderer());
            this.pushRenderMode(previousContext.getRenderMode());
        }
        if (entity != null) {
            this.latestVersionOfEntity = (ContentEntityObject)entity.getLatestVersion();
        }
    }

    public PageContext getOriginalContext() {
        if (this.originalContext == null) {
            return this;
        }
        return this.originalContext;
    }

    public String getSpaceKey() {
        if (this.latestVersionOfEntity instanceof SpaceContentEntityObject) {
            return ((SpaceContentEntityObject)this.latestVersionOfEntity).getSpaceKey();
        }
        if (this.latestVersionOfEntity instanceof PageContentEntityObject) {
            return ((PageContentEntityObject)this.latestVersionOfEntity).getPage().getSpaceKey();
        }
        if (this.entity instanceof Draft) {
            return ((Draft)this.entity).getDraftSpaceKey();
        }
        return this.spaceKey;
    }

    public String getPageTitle() {
        if (this.latestVersionOfEntity instanceof PageContentEntityObject) {
            return ((PageContentEntityObject)this.latestVersionOfEntity).getPage().getTitle();
        }
        return this.entity != null ? this.entity.getTitle() : null;
    }

    public Calendar getPostingDay() {
        if (this.postingDay == null && this.latestVersionOfEntity instanceof BlogPost) {
            this.postingDay = BlogPost.toCalendar(this.latestVersionOfEntity.getCreationDate());
        }
        return this.postingDay;
    }

    public ContentEntityObject getEntity() {
        return this.entity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PageContext)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PageContext pageContext = (PageContext)((Object)o);
        if (this.entity != null ? !this.entity.equals(pageContext.entity) : pageContext.entity != null) {
            return false;
        }
        if (this.originalContext != null ? !this.originalContext.equals((Object)pageContext.originalContext) : pageContext.originalContext != null) {
            return false;
        }
        return !(this.spaceKey != null ? !this.spaceKey.equals(pageContext.spaceKey) : pageContext.spaceKey != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.spaceKey != null ? this.spaceKey.hashCode() : 0);
        result = 29 * result + (this.entity != null ? this.entity.hashCode() : 0);
        result = 29 * result + (this.originalContext != null ? this.originalContext.hashCode() : 0);
        return result;
    }
}

