/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.renderer;

import com.atlassian.confluence.renderer.v2.macros.GenericVelocityMacro;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.Macro;
import com.atlassian.spring.container.ContainerManager;
import java.io.Serializable;

public class UserMacroConfig
implements Serializable {
    public static final String OUTPUT_TYPE_HTML = "html";
    public static final String OUTPUT_TYPE_WIKI = "wiki";
    public static final String BODY_TYPE_RAW = "raw";
    public static final String BODY_TYPE_ESCAPE_HTML = "escapehtml";
    public static final String BODY_TYPE_RENDERED = "rendered";
    private String template;
    private String name;
    private boolean hasBody;
    private String outputType = "html";
    private String bodyType = "raw";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.toLowerCase();
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public boolean isHasBody() {
        return this.hasBody;
    }

    public void setHasBody(boolean hasBody) {
        this.hasBody = hasBody;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public void setOutputType(String outputType) {
        if (outputType != null && !OUTPUT_TYPE_HTML.equals(outputType) && !OUTPUT_TYPE_WIKI.equals(outputType)) {
            throw new IllegalArgumentException("Unknown output type: " + outputType);
        }
        this.outputType = outputType;
    }

    public String getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(String bodyType) {
        if (!(bodyType == null || BODY_TYPE_ESCAPE_HTML.equals(bodyType) || BODY_TYPE_RAW.equals(bodyType) || BODY_TYPE_RENDERED.equals(bodyType))) {
            throw new IllegalArgumentException("Unknown body type: " + bodyType);
        }
        this.bodyType = bodyType;
    }

    public Macro toMacro() {
        GenericVelocityMacro velocityMacro = (GenericVelocityMacro)((Object)ContainerManager.getInstance().getContainerContext().createComponent(GenericVelocityMacro.class));
        velocityMacro.setVelocity(this.getTemplate());
        velocityMacro.setHasBody(this.isHasBody());
        if (OUTPUT_TYPE_WIKI.equals(this.getOutputType())) {
            velocityMacro.setRenderOutput(true);
        }
        if (BODY_TYPE_ESCAPE_HTML.equals(this.getBodyType())) {
            velocityMacro.setBodyRenderMode(RenderMode.allow((long)128L));
        }
        if (BODY_TYPE_RENDERED.equals(this.getBodyType())) {
            velocityMacro.setBodyRenderMode(RenderMode.suppress((long)256L));
        }
        return velocityMacro;
    }
}

