/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.renderer;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.renderer.UserMacroConfig;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class UserMacroLibrary {
    public static final String LIBRARY_KEY = "confluence.user";
    BandanaManager bandanaManager;

    public void addUpdateMacro(UserMacroConfig userMacroConfig) {
        if (userMacroConfig.getName() == null || userMacroConfig.getName().equals("")) {
            throw new IllegalArgumentException("User macro does not have a name: " + userMacroConfig);
        }
        Map userMacros = this.getBandanaMacros();
        userMacros.put(userMacroConfig.getName(), userMacroConfig);
        this.updateBandana(userMacros);
    }

    public boolean hasMacro(String name) {
        return this.getMacro(name) != null;
    }

    public UserMacroConfig getMacro(String name) {
        name = name.toLowerCase();
        Object storedConfig = this.getBandanaMacros().get(name);
        if (storedConfig instanceof String) {
            this.addUpdateMacro(this.migrateOldUserMacro(name, (String)storedConfig));
        }
        return (UserMacroConfig)this.getBandanaMacros().get(name);
    }

    public void removeMacro(String name) {
        Map userMacros = this.getBandanaMacros();
        userMacros.remove(name.toLowerCase());
        this.updateBandana(userMacros);
    }

    public SortedSet getMacroNames() {
        return new TreeSet(this.getBandanaMacros().keySet());
    }

    private Map getBandanaMacros() {
        Map result = (Map)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "atlassian.confluence.user.macros");
        if (result == null) {
            return new TreeMap();
        }
        return result;
    }

    private void updateBandana(Map userMacros) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "atlassian.confluence.user.macros", (Object)userMacros);
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    private UserMacroConfig migrateOldUserMacro(String name, String userMacroTemplate) {
        UserMacroConfig macroConfig = new UserMacroConfig();
        macroConfig.setTemplate(userMacroTemplate);
        macroConfig.setName(name.toLowerCase());
        macroConfig.setHasBody(true);
        return macroConfig;
    }
}

