/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.renderer.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.plugin.descriptor.CustomMacroModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.opensymphony.xwork.ActionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NotationHelpAction
extends ConfluenceActionSupport {
    String section;
    private Map macrosWithHelpBySection;
    private List macrosWithHelpNoSection;
    private PluginAccessor pluginAccessor;

    public String execute() throws Exception {
        if (this.section == null) {
            this.section = (String)ActionContext.getContext().getSession().get("confluence.help.notation.section");
            if (this.section == null) {
                this.section = "index";
            }
        }
        ActionContext.getContext().getSession().put("confluence.help.notation.section", this.section);
        return super.execute();
    }

    public String getSection() {
        return this.section;
    }

    public void setSection(String section) {
        this.section = section;
    }

    public Collection getMacroHelpForSection(String section) {
        if (this.macrosWithHelpBySection == null) {
            this.loadMacroHelp();
        }
        return (Collection)this.macrosWithHelpBySection.get(section);
    }

    public Collection getMacroHelpNoSection() {
        if (this.macrosWithHelpNoSection == null) {
            this.loadMacroHelp();
        }
        return this.macrosWithHelpNoSection;
    }

    private void loadMacroHelp() {
        this.macrosWithHelpBySection = new HashMap();
        this.macrosWithHelpNoSection = new ArrayList();
        List macroDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(CustomMacroModuleDescriptor.class);
        for (CustomMacroModuleDescriptor descriptor : macroDescriptors) {
            if (!descriptor.hasHelp()) continue;
            if (descriptor.getHelpSection() == null) {
                this.macrosWithHelpNoSection.add(descriptor);
                continue;
            }
            ArrayList<CustomMacroModuleDescriptor> list = (ArrayList<CustomMacroModuleDescriptor>)this.macrosWithHelpBySection.get(descriptor.getHelpSection());
            if (list == null) {
                list = new ArrayList<CustomMacroModuleDescriptor>();
            }
            list.add(descriptor);
            this.macrosWithHelpBySection.put(descriptor.getHelpSection(), list);
        }
    }

    public boolean isCamelCaseEnabled() {
        return this.settingsManager.getGlobalSettings().isAllowCamelCase();
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }
}

