/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.renderer.attachments;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.thumbnail.ThumbnailInfo;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.embedded.EmbeddedResourceUtils;
import com.atlassian.confluence.renderer.embedded.ImagePathHelper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.ConfluenceRenderUtils;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.attachments.RendererAttachment;
import com.atlassian.renderer.embedded.EmbeddedImage;
import com.atlassian.renderer.embedded.EmbeddedResource;
import com.atlassian.renderer.util.UrlUtil;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.io.InputStream;
import java.sql.Timestamp;

public class RendererAttachmentManager
implements com.atlassian.renderer.attachments.RendererAttachmentManager,
ImagePathHelper {
    private PermissionManager permissionManager;

    public RendererAttachment getAttachment(RenderContext renderContext, EmbeddedResource embeddedResource) {
        Attachment confAttachment = EmbeddedResourceUtils.resolveAttachment((PageContext)renderContext, embeddedResource);
        if (confAttachment == null || !this.isPermittedToViewAttachment(confAttachment)) {
            return null;
        }
        return this.convertToRendererAttachment(confAttachment, renderContext, embeddedResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RendererAttachment getThumbnail(RendererAttachment rendererAttachment, RenderContext renderContext, EmbeddedImage embeddedImage) {
        String fileName = UrlUtil.escapeSpecialCharacters((String)embeddedImage.getFilename());
        AttachmentManager attachmentManager = (AttachmentManager)ContainerManager.getComponent((String)"attachmentManager");
        ThumbnailManager thumbnailManager = (ThumbnailManager)ContainerManager.getComponent((String)"thumbnailManager");
        Attachment attachment = EmbeddedResourceUtils.resolveAttachment((PageContext)renderContext, (EmbeddedResource)embeddedImage);
        if (attachment == null && !renderContext.isRenderingForWysiwyg()) {
            throw new RuntimeException("Attachment " + fileName + " was not found");
        }
        ThumbnailInfo thumb = null;
        InputStream attachmentData = null;
        if (attachment != null) {
            String attachmentsRemotePath = this.getImagePath(attachment, true);
            try {
                attachmentData = attachmentManager.getAttachmentData(attachment);
                if (attachmentData == null) {
                    throw new RuntimeException("Could not generate thumbnail: Attachment file not found");
                }
                thumb = new ThumbnailInfo(attachment, attachmentData, attachmentsRemotePath);
            }
            finally {
                IOUtils.close(attachmentData);
            }
            if (!thumbnailManager.isThumbnailable(attachment)) {
                throw new RuntimeException("Could not generate thumbnail: Image file format not supported");
            }
        }
        if (thumb != null) {
            if (renderContext.isRenderingForWysiwyg()) {
                return new RendererAttachment(attachment.getId(), attachment.getFileName(), attachment.getContentType(), attachment.getCreatorName(), attachment.getComment(), thumb.getThumbnailUrlPath(), null, null, new Timestamp(attachment.getCreationDate().getTime()));
            }
            return new RendererAttachment(attachment.getId(), attachment.getFileName(), attachment.getContentType(), attachment.getCreatorName(), attachment.getComment(), thumb.getThumbnailUrlPath(), thumb.getPopupLinkPrefix(), thumb.getPopupLinkSuffix(), new Timestamp(attachment.getCreationDate().getTime()));
        }
        return null;
    }

    public boolean systemSupportsThumbnailing() {
        return ThumbnailInfo.systemSupportsThumbnailing();
    }

    private RendererAttachment convertToRendererAttachment(Attachment attachment, RenderContext context, EmbeddedResource resource) {
        String objectUrl = "";
        String attachmentsPath = context.getAttachmentsPath();
        if (attachmentsPath == null) {
            attachmentsPath = this.getImagePath(attachment, false);
        }
        if (attachmentsPath != null) {
            objectUrl = UrlUtil.escapeSpecialCharacters((String)attachmentsPath) + "/";
        }
        objectUrl = objectUrl + UrlUtil.escapeSpecialCharacters((String)resource.getFilename());
        return new RendererAttachment(attachment.getId(), attachment.getFileName(), attachment.getContentType(), attachment.getCreatorName(), attachment.getComment(), objectUrl, null, null, new Timestamp(attachment.getCreationDate().getTime()));
    }

    public String getImagePath(Attachment attachment, boolean isThumbnail) {
        return ConfluenceRenderUtils.getAttachmentRemotePath(attachment);
    }

    protected boolean isPermittedToViewAttachment(Attachment attachment) {
        User user = AuthenticatedUserThreadLocal.getUser();
        return GeneralUtil.isSuperUser(user) || this.permissionManager.hasPermission(user, Permission.VIEW, attachment);
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }
}

